/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;

@RequiresApi(value=19)
final class FadeDrawable
extends LayerDrawable {
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 3;
    private static final int START_DRAWABLE = 0;
    private static final int END_DRAWABLE = 1;
    private final long mFadeDuration;
    private final int mStartAlpha;
    private final int mEndAlpha;
    private long mStartTime;
    private int mFadeState = 0;
    private boolean mIgnoreInvalidation;

    public FadeDrawable(@NonNull Drawable startDrawable, @NonNull Drawable endDrawable, long fadeDuration) {
        super(new Drawable[]{startDrawable, endDrawable});
        this.mFadeDuration = fadeDuration;
        this.mStartAlpha = startDrawable.getAlpha();
        this.mEndAlpha = endDrawable.getAlpha();
    }

    public void draw(Canvas canvas) {
        switch (this.mFadeState) {
            case 0: {
                this.getDrawable(0).draw(canvas);
                this.mStartTime = SystemClock.uptimeMillis();
                this.mFadeState = 1;
                this.invalidateSelf();
                break;
            }
            case 1: {
                boolean done;
                this.mIgnoreInvalidation = true;
                long elapsed = SystemClock.uptimeMillis() - this.mStartTime;
                int endAlpha = (int)((long)this.mEndAlpha * elapsed / this.mFadeDuration);
                Drawable startDrawable = this.getDrawable(0);
                Drawable endDrawable = this.getDrawable(1);
                boolean bl = done = endAlpha >= this.mEndAlpha;
                if (done) {
                    this.mFadeState = 3;
                    endDrawable.setAlpha(this.mEndAlpha);
                    endDrawable.draw(canvas);
                } else {
                    startDrawable.setAlpha(Math.max(this.mStartAlpha - (int)((long)this.mStartAlpha * elapsed / this.mFadeDuration), 0));
                    startDrawable.draw(canvas);
                    endDrawable.setAlpha(endAlpha);
                    endDrawable.draw(canvas);
                }
                this.mIgnoreInvalidation = false;
                if (done) break;
                this.invalidateSelf();
                break;
            }
            case 3: {
                this.getDrawable(1).draw(canvas);
            }
        }
    }

    public void invalidateSelf() {
        if (!this.mIgnoreInvalidation) {
            super.invalidateSelf();
        }
    }

    public void invalidateDrawable(@NonNull Drawable drawable) {
        if (!this.mIgnoreInvalidation) {
            super.invalidateDrawable(drawable);
        }
    }
}

