/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.CacheImageAction;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataLocation;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageNotLoadedException;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.Size;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class BaseLoadImageAction<T>
implements Callable<Void> {
    private final DataDescriptor<T> mDescriptor;
    private final BitmapLoader<T> mBitmapLoader;
    private final Size mRequiredSize;
    private final BitmapTransformation mTransformation;
    private final PauseLock mPauseLock;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final ExecutorService mCacheExecutor;
    private final LoadCallback mLoadCallback;
    private final ErrorCallback mErrorCallback;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private volatile Future<?> mLoadFuture;
    private volatile CacheImageAction mCacheAction;

    protected BaseLoadImageAction(@NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @Nullable Size requiredSize, @Nullable BitmapTransformation transformation, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable ExecutorService cacheExecutor, @Nullable LoadCallback loadCallback, @Nullable ErrorCallback errorCallback, @NonNull PauseLock pauseLock) {
        this.mDescriptor = descriptor;
        this.mBitmapLoader = bitmapLoader;
        this.mRequiredSize = requiredSize;
        this.mTransformation = transformation;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mCacheExecutor = cacheExecutor;
        this.mLoadCallback = loadCallback;
        this.mErrorCallback = errorCallback;
    }

    @WorkerThread
    protected abstract void onImageLoaded(@NonNull Bitmap var1);

    @WorkerThread
    protected abstract void onError(@NonNull Throwable var1);

    @AnyThread
    protected abstract void onCancelled();

    @AnyThread
    public final void submit(@NonNull ExecutorService executor) {
        if (this.isCancelled()) {
            return;
        }
        this.mLoadFuture = executor.submit(this);
    }

    @AnyThread
    public final void cancel() {
        if (this.mCancelled.compareAndSet(false, true)) {
            CacheImageAction cacheAction;
            Future<?> loadFuture = this.mLoadFuture;
            if (loadFuture != null) {
                loadFuture.cancel(false);
            }
            if ((cacheAction = this.mCacheAction) != null) {
                cacheAction.cancel();
            }
            this.onCancelled();
        }
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    @Override
    public final Void call() throws Exception {
        this.loadImage();
        this.mLoadFuture = null;
        return null;
    }

    @NonNull
    protected final DataDescriptor<T> getDescriptor() {
        return this.mDescriptor;
    }

    @Nullable
    protected final String getKey() {
        return InternalUtils.buildFullKey(this.mDescriptor.getKey(), this.mRequiredSize, this.mTransformation);
    }

    @Nullable
    protected final Size getRequiredSize() {
        return this.mRequiredSize;
    }

    @NonNull
    protected final BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    @NonNull
    protected final PauseLock getPauseLock() {
        return this.mPauseLock;
    }

    @Nullable
    protected final ImageCache getMemoryCache() {
        return this.mMemoryCache;
    }

    @Nullable
    protected final ImageCache getStorageCache() {
        return this.mStorageCache;
    }

    @Nullable
    protected final LoadCallback getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    protected final ErrorCallback getErrorCallback() {
        return this.mErrorCallback;
    }

    @WorkerThread
    protected final void loadImage() {
        Bitmap image;
        while (!this.isCancelled() && !this.mPauseLock.shouldInterruptEarly() && this.mPauseLock.isPaused()) {
            try {
                this.mPauseLock.await();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.isCancelled() || this.mPauseLock.shouldInterruptEarly()) {
            return;
        }
        DataDescriptor<T> descriptor = this.mDescriptor;
        String key = this.getKey();
        T data = descriptor.getData();
        ImageCache memoryCache = this.mMemoryCache;
        if (key != null && memoryCache != null && (image = memoryCache.get(key)) != null) {
            this.processImage(image);
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ImageCache storageCache = this.mStorageCache;
        if (key != null && storageCache != null && (image = storageCache.get(key)) != null) {
            this.processImage(image);
            if (memoryCache != null) {
                memoryCache.put(key, image);
            }
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        Size requiredSize = this.mRequiredSize;
        try {
            image = this.mBitmapLoader.load(data, requiredSize);
        }
        catch (Throwable error) {
            this.processError(error);
            return;
        }
        if (image == null) {
            this.processError(new ImageNotLoadedException());
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        BitmapTransformation transformation = this.mTransformation;
        if (transformation != null) {
            try {
                Bitmap transformed = transformation.transform(image);
                if (image != transformed && !image.isRecycled()) {
                    image.recycle();
                }
                image = transformed;
            }
            catch (Throwable error) {
                this.processError(error);
                return;
            }
        }
        if (this.isCancelled()) {
            return;
        }
        this.processImage(image);
        if (key != null) {
            if (memoryCache != null) {
                memoryCache.put(key, image);
            }
            if (storageCache != null && (requiredSize != null || transformation != null || descriptor.getLocation() != DataLocation.LOCAL)) {
                ExecutorService cacheExecutor = this.mCacheExecutor;
                if (cacheExecutor != null) {
                    this.mCacheAction = new CacheImageAction(key, image, storageCache).submit(cacheExecutor);
                } else {
                    storageCache.put(key, image);
                }
            }
        }
    }

    @WorkerThread
    private void processImage(@NonNull Bitmap image) {
        LoadCallback loadCallback = this.mLoadCallback;
        if (loadCallback != null) {
            loadCallback.onLoaded(image);
        }
        this.onImageLoaded(image);
    }

    @WorkerThread
    private void processError(@NonNull Throwable error) {
        ErrorCallback errorCallback = this.mErrorCallback;
        if (errorCallback != null) {
            errorCallback.onError(error);
        }
        this.onError(error);
    }
}

