/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ImageLoaderThreadFactory
implements ThreadFactory {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(1);
    private static final String THREAD_NAME_PREFIX = "ImageLoader thread #";

    ImageLoaderThreadFactory() {
    }

    @Override
    @NonNull
    public Thread newThread(@NonNull Runnable r) {
        THREAD_COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        Thread t = new Thread(r, THREAD_NAME_PREFIX + THREAD_COUNTER.getAndIncrement());
        if (t.getPriority() != 1) {
            t.setPriority(1);
        }
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        return t;
    }
}

