/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.StorageImageCache;
import java.io.File;
import java.util.concurrent.ExecutorService;

public final class ImageLoaderBuilder {
    private final Context mContext;
    private ImageCache mMemoryCache;
    private ImageCache mStorageCache;
    private ExecutorService mLoadExecutor;
    private ExecutorService mCacheExecutor;

    ImageLoaderBuilder(@NonNull Context context) {
        this.mContext = context;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache() {
        this.mMemoryCache = new MemoryImageCache();
        return this;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache(int maxSize) {
        this.mMemoryCache = new MemoryImageCache(maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache(@Nullable ImageCache memoryCache) {
        this.mMemoryCache = memoryCache;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache() {
        this.mStorageCache = new StorageImageCache(this.mContext);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(long maxSize) {
        this.mStorageCache = new StorageImageCache(this.mContext, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull CompressMode compressMode, long maxSize) {
        this.mStorageCache = new StorageImageCache(this.mContext, compressMode, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory) {
        this.mStorageCache = new StorageImageCache(directory);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory, long maxSize) {
        this.mStorageCache = new StorageImageCache(directory, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mStorageCache = new StorageImageCache(directory, compressMode, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@Nullable ImageCache storageCache) {
        this.mStorageCache = storageCache;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder loadExecutor(@Nullable ExecutorService executor) {
        this.mLoadExecutor = executor;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder cacheExecutor(@Nullable ExecutorService executor) {
        this.mCacheExecutor = executor;
        return this;
    }

    @NonNull
    public ImageLoader build() {
        ExecutorService cacheExecutor;
        ExecutorService loadExecutor = this.mLoadExecutor;
        if (loadExecutor == null) {
            loadExecutor = new ImageLoaderExecutor(InternalUtils.getPoolSize());
        }
        if ((cacheExecutor = this.mCacheExecutor) == null) {
            cacheExecutor = new ImageLoaderExecutor();
        }
        return new ImageLoader(this.mContext, loadExecutor, cacheExecutor, this.mMemoryCache, this.mStorageCache);
    }
}

