/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageCache;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class CacheImageAction
implements Callable<Void> {
    private final String mKey;
    private final WeakReference<Bitmap> mImage;
    private final ImageCache mCache;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;

    public CacheImageAction(@NonNull String key, @NonNull Bitmap image, @NonNull ImageCache cache) {
        this.mKey = key;
        this.mImage = new WeakReference<Bitmap>(image);
        this.mCache = cache;
    }

    @NonNull
    public CacheImageAction submit(@NonNull ExecutorService executor) {
        this.mFuture = executor.submit(this);
        return this;
    }

    public void cancel() {
        this.mCancelled = true;
        this.mFuture.cancel(true);
        this.mImage.clear();
    }

    @Override
    public Void call() throws Exception {
        Bitmap image;
        if (!this.mCancelled && (image = (Bitmap)this.mImage.get()) != null) {
            this.mCache.put(this.mKey, image);
        }
        return null;
    }
}

