/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.ByteBuffer;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;

final class StorageImageCache
implements ImageCache {
    public static final String DEFAULT_DIRECTORY = "image_loader_cache";
    public static final long DEFAULT_MAX_SIZE = 0x6400000L;
    private static final int BUFFER_SIZE = 16384;
    private final FileFilter mFileFilter = new CacheFileFilter();
    private final Comparator<File> mFileComparator = new FileComparator();
    private final AtomicBoolean mTrimming = new AtomicBoolean();
    private final CompressMode mCompressMode;
    private final File mDirectory;
    private final long mMaxSize;

    public StorageImageCache(@NonNull Context context) {
        this(StorageImageCache.getDefaultDirectory(context));
    }

    public StorageImageCache(@NonNull Context context, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), maxSize);
    }

    public StorageImageCache(@NonNull Context context, @NonNull CompressMode compressMode, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), compressMode, maxSize);
    }

    public StorageImageCache(@NonNull File directory) {
        this(directory, 0x6400000L);
    }

    public StorageImageCache(@NonNull File directory, long maxSize) {
        this(directory, CompressMode.LOSSLESS, maxSize);
    }

    public StorageImageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mDirectory = directory;
        this.mCompressMode = compressMode;
        this.mMaxSize = maxSize;
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        Bitmap bitmap = null;
        FileInputStream inputStream = null;
        try {
            int read;
            inputStream = new FileInputStream(file);
            ByteBuffer outputBuffer = new ByteBuffer(16384);
            byte[] buffer = new byte[16384];
            while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputBuffer.write(buffer, 0, read);
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])outputBuffer.getArray(), (int)0, (int)outputBuffer.getSize());
        }
        catch (IOException iOException) {
            InternalUtils.close(inputStream);
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
        }
        InternalUtils.close(inputStream);
        if (bitmap != null) {
            file.setLastModified(System.currentTimeMillis());
            return bitmap;
        }
        file.delete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        block8: {
            boolean success;
            File file = this.getFile(key);
            if (file.exists()) {
                file.delete();
            }
            ByteBuffer outputBuffer = new ByteBuffer(16384);
            if (!value.compress(this.mCompressMode.getFormat(), this.mCompressMode.getQuality(), (OutputStream)outputBuffer)) break block8;
            byte[] array = outputBuffer.getArray();
            int size = outputBuffer.getSize();
            FileOutputStream output = null;
            try {
                int write;
                output = new FileOutputStream(file);
                for (int remaining = size; remaining > 0; remaining -= write) {
                    write = Math.min(remaining, 16384);
                    output.write(array, size - remaining, write);
                }
                success = true;
            }
            catch (IOException e) {
                try {
                    success = false;
                }
                catch (Throwable throwable) {
                    InternalUtils.close(output);
                    throw throwable;
                }
                InternalUtils.close(output);
            }
            InternalUtils.close(output);
            if (success) {
                this.trim();
            } else {
                file.delete();
            }
        }
    }

    @Override
    public void remove(@NonNull String key) {
        File[] files = this.mDirectory.listFiles(new RemoveFileFilter(key));
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    @Override
    public void clear() {
        File[] files = this.getFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    @NonNull
    private File getFile(@NonNull String key) {
        return new File(this.mDirectory, key);
    }

    @Nullable
    private File[] getFiles() {
        return this.mDirectory.listFiles(this.mFileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trim() {
        if (this.mTrimming.compareAndSet(false, true)) {
            try {
                File[] files = this.getFiles();
                if (files != null && files.length != 0) {
                    Arrays.sort(files, this.mFileComparator);
                    long size = 0L;
                    boolean removing = false;
                    for (File cached : files) {
                        if (removing) {
                            cached.delete();
                            continue;
                        }
                        if ((size += cached.length()) < this.mMaxSize) continue;
                        removing = true;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.mTrimming.set(false);
            }
        }
    }

    @NonNull
    private static File getDefaultDirectory(@NonNull Context context) {
        File directory = context.getExternalCacheDir();
        if (directory == null) {
            directory = context.getCacheDir();
        }
        return new File(directory, DEFAULT_DIRECTORY);
    }

    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(@NonNull File lhs, @NonNull File rhs) {
            return Long.signum(rhs.lastModified() - lhs.lastModified());
        }
    }

    private static final class RemoveFileFilter
    implements FileFilter {
        private final String mName;

        private RemoveFileFilter(@NonNull String name) {
            this.mName = name.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().toLowerCase().startsWith(this.mName);
        }
    }

    private static final class CacheFileFilter
    implements FileFilter {
        private CacheFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }
}

