/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.media.ExifInterface;
import android.view.View;
import android.widget.ImageView;
import com.budiyev.android.imageloader.CacheMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageUtils;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

final class InternalUtils {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int MAX_POOL_SIZE = 4;
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private static final String URI_SCHEME_FTP = "ftp";

    private InternalUtils() {
    }

    public static void invalidate(@Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @NonNull DataDescriptor<?> descriptor) {
        String key = descriptor.getKey();
        if (key == null) {
            return;
        }
        CacheMode cacheMode = descriptor.getCacheMode();
        if (memoryCache != null && (cacheMode == null || cacheMode.isMemoryCacheEnabled())) {
            memoryCache.remove(key);
        }
        if (storageCache != null && (cacheMode == null || cacheMode.isStorageCacheEnabled())) {
            storageCache.remove(key);
        }
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static InputStream getDataStreamFromUri(@NonNull Context context, @NonNull Uri uri) throws IOException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_HTTP.equalsIgnoreCase(scheme) || URI_SCHEME_HTTPS.equalsIgnoreCase(scheme) || URI_SCHEME_FTP.equalsIgnoreCase(scheme)) {
            URLConnection connection = new URL(uri.toString()).openConnection();
            connection.setConnectTimeout(10000);
            return connection.getInputStream();
        }
        return context.getContentResolver().openInputStream(uri);
    }

    @Nullable
    public static InputStream getDataStreamFromUrl(@NonNull String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(10000);
        return connection.getInputStream();
    }

    @Nullable
    @MainThread
    public static DisplayImageAction<?> getDisplayImageAction(@Nullable View view) {
        Drawable drawable;
        if (view != null && (drawable = InternalUtils.getDrawable(view)) instanceof PlaceholderDrawable) {
            return ((PlaceholderDrawable)drawable).getAction();
        }
        return null;
    }

    public static void setDrawable(@NonNull Drawable drawable, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static void setBitmap(@NonNull Resources resources, @NonNull Bitmap bitmap, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageBitmap(bitmap);
        } else {
            BitmapDrawable drawable = new BitmapDrawable(resources, bitmap);
            if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground((Drawable)drawable);
            } else {
                view.setBackgroundDrawable((Drawable)drawable);
            }
        }
    }

    @Nullable
    public static Drawable getDrawable(@NonNull View view) {
        if (view instanceof ImageView) {
            return ((ImageView)view).getDrawable();
        }
        return view.getBackground();
    }

    public static int getPoolSize() {
        return Math.min(Runtime.getRuntime().availableProcessors(), 4);
    }

    public static boolean isUriLocal(@NonNull Uri uri) {
        String scheme = uri.getScheme();
        return "file".equals(scheme) || "content".equals(scheme) || "android.resource".equals(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExifRotation(@NonNull Context context, @NonNull Uri uri) {
        int n;
        InputStream inputStream;
        block5: {
            inputStream = null;
            inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream == null) break block5;
            int n2 = InternalUtils.getExifRotation(new ExifInterface(inputStream));
            InternalUtils.close(inputStream);
            return n2;
        }
        try {
            n = 0;
        }
        catch (IOException e) {
            int n3;
            try {
                n3 = 0;
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
            return n3;
        }
        InternalUtils.close(inputStream);
        return n;
    }

    public static int getExifRotation(@NonNull File file) {
        try {
            return InternalUtils.getExifRotation(new ExifInterface(file.getAbsolutePath()));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static int getExifRotation(@NonNull byte[] bytes) {
        try {
            return InternalUtils.getExifRotation(new ExifInterface((InputStream)new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static int getExifRotation(@NonNull ExifInterface exifInterface) {
        switch (exifInterface.getAttributeInt("Orientation", 1)) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    @NonNull
    public static Bitmap rotateAndRecycle(@NonNull Bitmap bitmap, int rotation) {
        Bitmap rotated = ImageUtils.rotate(bitmap, rotation);
        if (bitmap != rotated) {
            bitmap.recycle();
        }
        return rotated;
    }
}

