/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.CommonDataDescriptorFactory;
import com.budiyev.android.imageloader.DataDescriptorFactory;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDataDescriptorFactory;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageRequest;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.ResourceDataDescriptorFactory;
import com.budiyev.android.imageloader.UnidentifiableDataDescriptorFactory;
import com.budiyev.android.imageloader.UriBitmapLoader;
import com.budiyev.android.imageloader.UriDataDescriptorFactory;
import com.budiyev.android.imageloader.UrlBitmapLoader;
import com.budiyev.android.imageloader.UrlDataDescriptorFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class ImageRequestFactory {
    private final BitmapLoader<Uri> mUriBitmapLoader = new UriBitmapLoader();
    private final BitmapLoader<String> mUrlBitmapLoader = new UrlBitmapLoader();
    private final BitmapLoader<File> mFileBitmapLoader = new FileBitmapLoader();
    private final BitmapLoader<FileDescriptor> mFileDescriptorBitmapLoader = new FileDescriptorBitmapLoader();
    private final BitmapLoader<Integer> mResourceBitmapLoader = new ResourceBitmapLoader();
    private final BitmapLoader<byte[]> mByteArrayBitmapLoader = new ByteArrayBitmapLoader();
    private final DataDescriptorFactory<Uri> mUriDataDescriptorFactory = new UriDataDescriptorFactory();
    private final DataDescriptorFactory<String> mUrlDataDescriptorFactory = new UrlDataDescriptorFactory();
    private final DataDescriptorFactory<File> mFileDataDescriptorFactory = new FileDataDescriptorFactory();
    private final DataDescriptorFactory<FileDescriptor> mFileDescriptorDataDescriptorFactory = new UnidentifiableDataDescriptorFactory<FileDescriptor>();
    private final DataDescriptorFactory<Integer> mResourceDataDescriptorFactory = new ResourceDataDescriptorFactory();
    private final DataDescriptorFactory<byte[]> mByteArrayDataDescriptorFactory = new UnidentifiableDataDescriptorFactory<byte[]>();
    private final DataDescriptorFactory<Object> mCommonDataDescriptorFactory = new CommonDataDescriptorFactory();
    private final Context mContext;
    private final ExecutorService mExecutor;
    private final PauseLock mPauseLock;
    private final Handler mMainThreadHandler;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;

    ImageRequestFactory(@NonNull Context context, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mPauseLock = pauseLock;
        this.mMainThreadHandler = new Handler(context.getMainLooper());
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
    }

    @NonNull
    public ImageRequest<Uri> uri() {
        return new ImageRequest<Uri>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mUriBitmapLoader, this.mUriDataDescriptorFactory);
    }

    @NonNull
    public ImageRequest<String> url() {
        return new ImageRequest<String>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mUrlBitmapLoader, this.mUrlDataDescriptorFactory);
    }

    @NonNull
    public ImageRequest<File> file() {
        return new ImageRequest<File>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mFileBitmapLoader, this.mFileDataDescriptorFactory);
    }

    @NonNull
    public ImageRequest<FileDescriptor> fileDescriptor() {
        return new ImageRequest<FileDescriptor>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mFileDescriptorBitmapLoader, this.mFileDescriptorDataDescriptorFactory);
    }

    @NonNull
    public ImageRequest<Integer> resource() {
        return new ImageRequest<Integer>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mResourceBitmapLoader, this.mResourceDataDescriptorFactory);
    }

    @NonNull
    public ImageRequest<byte[]> byteArray() {
        return new ImageRequest<byte[]>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mByteArrayBitmapLoader, this.mByteArrayDataDescriptorFactory);
    }

    @NonNull
    <T> ImageRequest<T> custom(@NonNull BitmapLoader<T> loader) {
        return new ImageRequest<Object>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, loader, this.mCommonDataDescriptorFactory);
    }

    @NonNull
    <T> ImageRequest<T> custom(@NonNull BitmapLoader<T> loader, @NonNull DataDescriptorFactory<T> factory) {
        return new ImageRequest<T>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, loader, factory);
    }
}

