/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.ImageCache;
import java.util.concurrent.Callable;

final class InvalidateAction
implements Callable<Void> {
    private final DataDescriptor<?> mDescriptor;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;

    public InvalidateAction(@NonNull DataDescriptor<?> descriptor, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache) {
        this.mDescriptor = descriptor;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
    }

    @Override
    public Void call() throws Exception {
        DataDescriptor<?> descriptor = this.mDescriptor;
        String key = descriptor.getKey();
        if (key != null) {
            ImageCache storageCache;
            ImageCache memoryCache = this.mMemoryCache;
            if (memoryCache != null && descriptor.isMemoryCachingEnabled()) {
                memoryCache.remove(key);
            }
            if ((storageCache = this.mStorageCache) != null && descriptor.isStorageCachingEnabled()) {
                storageCache.remove(key);
            }
        }
        return null;
    }
}

