/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.BitmapTransformation;

public final class ImageUtils {
    private ImageUtils() {
    }

    @NonNull
    public static BitmapTransformation invertColors() {
        return new InvertColorsTransformation();
    }

    @NonNull
    public static BitmapTransformation convertToGrayScale() {
        return new GrayScaleTransformation();
    }

    @NonNull
    public static BitmapTransformation tint(@ColorInt int color) {
        return new TintTransformation(color, PorterDuff.Mode.SRC_ATOP);
    }

    @NonNull
    public static BitmapTransformation tint(@ColorInt int color, @NonNull PorterDuff.Mode mode) {
        return new TintTransformation(color, mode);
    }

    @NonNull
    public static BitmapTransformation mirrorHorizontally() {
        return new MirrorHorizontallyTransformation();
    }

    @NonNull
    public static BitmapTransformation mirrorVertically() {
        return new MirrorVerticallyTransformation();
    }

    @NonNull
    public static BitmapTransformation rotate(float rotationAngle) {
        return new RotateTransformation(rotationAngle);
    }

    @NonNull
    public static BitmapTransformation roundCorners() {
        return new RoundCornersTransformation();
    }

    @NonNull
    public static BitmapTransformation roundCorners(float cornerRadius) {
        return new RoundCornersTransformation(cornerRadius);
    }

    @NonNull
    public static BitmapTransformation cropCenter() {
        return new CropCenterTransformation();
    }

    @NonNull
    public static BitmapTransformation cropCenter(int resultWidth, int resultHeight) {
        return new CropCenterTransformation(resultWidth, resultHeight);
    }

    @NonNull
    public static BitmapTransformation fitCenter(int resultWidth, int resultHeight) {
        return new FitCenterTransformation(resultWidth, resultHeight);
    }

    @NonNull
    public static BitmapTransformation scaleToFit(int resultWidth, int resultHeight) {
        return new ScaleToFitTransformation(resultWidth, resultHeight, false);
    }

    @NonNull
    public static BitmapTransformation scaleToFit(int resultWidth, int resultHeight, boolean upscale) {
        return new ScaleToFitTransformation(resultWidth, resultHeight, upscale);
    }

    @NonNull
    public static Bitmap invertColors(@NonNull Bitmap image) {
        return ImageUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}));
    }

    @NonNull
    public static Bitmap convertToGrayScale(@NonNull Bitmap image) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return ImageUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(colorMatrix));
    }

    @NonNull
    public static Bitmap tint(@NonNull Bitmap image, @ColorInt int color) {
        return ImageUtils.tint(image, color, PorterDuff.Mode.SRC_ATOP);
    }

    @NonNull
    public static Bitmap tint(@NonNull Bitmap image, @ColorInt int color, @NonNull PorterDuff.Mode mode) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return ImageUtils.applyColorFilter(image, (ColorFilter)new PorterDuffColorFilter(color, mode));
    }

    @NonNull
    public static Bitmap applyColorFilter(@NonNull Bitmap image, @NonNull ColorFilter colorFilter) {
        Paint paint = new Paint(3);
        paint.setColorFilter(colorFilter);
        Bitmap bitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        new Canvas(bitmap).drawBitmap(image, 0.0f, 0.0f, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap mirrorHorizontally(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap mirrorVertically(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f, -1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap rotate(@NonNull Bitmap image, float rotationAngle) {
        Matrix matrix = new Matrix();
        matrix.setRotate(rotationAngle);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap roundCorners(@NonNull Bitmap image, float cornerRadius) {
        Paint paint = new Paint(3);
        paint.setColor(-12434878);
        int width = image.getWidth();
        int height = image.getHeight();
        Rect rect = new Rect(0, 0, width, height);
        RectF rectF = new RectF(rect);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(image, rect, rect, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap cropCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        Bitmap cropped;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int cropWidth = resultRatioWidth * sourceHeight / resultRatioHeight;
        if (cropWidth > sourceWidth) {
            int cropHeight = resultRatioHeight * sourceWidth / resultRatioWidth;
            cropped = Bitmap.createBitmap((Bitmap)image, (int)0, (int)((sourceHeight - cropHeight) / 2), (int)sourceWidth, (int)cropHeight);
            if (cropHeight == resultHeight && sourceWidth == resultWidth) {
                return cropped;
            }
        } else {
            cropped = Bitmap.createBitmap((Bitmap)image, (int)((sourceWidth - cropWidth) / 2), (int)0, (int)cropWidth, (int)sourceHeight);
            if (cropWidth == resultWidth && sourceHeight == resultHeight) {
                return cropped;
            }
        }
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)cropped, (int)resultWidth, (int)resultHeight, (boolean)true);
        if (cropped != image && cropped != scaled) {
            cropped.recycle();
        }
        return scaled;
    }

    @NonNull
    public static Bitmap fitCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        Bitmap result = Bitmap.createBitmap((int)resultWidth, (int)resultHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        result.setDensity(image.getDensity());
        Canvas canvas = new Canvas(result);
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            int top = (resultHeight - fitHeight) / 2;
            canvas.drawBitmap(image, null, new Rect(0, top, resultWidth, top + fitHeight), new Paint(3));
        } else {
            int left = (resultWidth - fitWidth) / 2;
            canvas.drawBitmap(image, null, new Rect(left, 0, left + fitWidth, resultHeight), new Paint(3));
        }
        return result;
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        return ImageUtils.scaleToFit(image, resultWidth, resultHeight, false);
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight, boolean upscale) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        if (!upscale && sourceWidth < resultWidth && sourceHeight < resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            if (sourceWidth == resultWidth) {
                return image;
            }
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)fitHeight, (boolean)true);
        }
        if (sourceHeight == resultHeight) {
            return image;
        }
        return Bitmap.createScaledBitmap((Bitmap)image, (int)fitWidth, (int)resultHeight, (boolean)true);
    }

    private static int greatestCommonDivisor(int a, int b) {
        while (a > 0 && b > 0) {
            if (a > b) {
                a %= b;
                continue;
            }
            b %= a;
        }
        return a + b;
    }

    private static final class ScaleToFitTransformation
    implements BitmapTransformation {
        private final int mWidth;
        private final int mHeight;
        private final boolean mUpscale;
        private final String mKey;

        public ScaleToFitTransformation(int width, int height, boolean upscale) {
            this.mWidth = width;
            this.mHeight = height;
            this.mUpscale = upscale;
            this.mKey = "_scale_to_fit_" + upscale + "_" + width + "x" + height;
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.scaleToFit(bitmap, this.mWidth, this.mHeight, this.mUpscale);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class FitCenterTransformation
    implements BitmapTransformation {
        private final int mWidth;
        private final int mHeight;
        private final String mKey;

        public FitCenterTransformation(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            this.mKey = "_fit_center_" + width + "x" + height;
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.fitCenter(bitmap, this.mWidth, this.mHeight);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class CropCenterTransformation
    implements BitmapTransformation {
        private final int mWidth;
        private final int mHeight;
        private final String mKey;

        public CropCenterTransformation(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            this.mKey = "_crop_center_" + width + "x" + height;
        }

        public CropCenterTransformation() {
            this.mWidth = -1;
            this.mHeight = -1;
            this.mKey = "_crop_center_square";
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            if (this.mWidth > 0 && this.mHeight > 0) {
                return ImageUtils.cropCenter(bitmap, this.mWidth, this.mHeight);
            }
            int size = Math.min(bitmap.getWidth(), bitmap.getHeight());
            return ImageUtils.cropCenter(bitmap, size, size);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class RoundCornersTransformation
    implements BitmapTransformation {
        private final float mRadius;
        private final String mKey;

        public RoundCornersTransformation(float radius) {
            this.mRadius = radius;
            this.mKey = "_round_corners_" + radius;
        }

        public RoundCornersTransformation() {
            this.mRadius = -1.0f;
            this.mKey = "_round_corners_max";
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            float radius = this.mRadius;
            if (radius == -1.0f) {
                radius = (float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f;
            }
            return ImageUtils.roundCorners(bitmap, radius);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class RotateTransformation
    implements BitmapTransformation {
        private final float mAngle = angle %= 360.0f;
        private final String mKey;

        public RotateTransformation(float angle) {
            this.mKey = "_rotate_" + angle;
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.rotate(bitmap, this.mAngle);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class MirrorVerticallyTransformation
    implements BitmapTransformation {
        private MirrorVerticallyTransformation() {
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.mirrorVertically(bitmap);
        }

        @Override
        @NonNull
        public String getKey() {
            return "_mirror_vertically";
        }
    }

    private static final class MirrorHorizontallyTransformation
    implements BitmapTransformation {
        private MirrorHorizontallyTransformation() {
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.mirrorHorizontally(bitmap);
        }

        @Override
        @NonNull
        public String getKey() {
            return "_mirror_horizontally";
        }
    }

    private static final class TintTransformation
    implements BitmapTransformation {
        private final int mColor;
        private final PorterDuff.Mode mMode;
        private final String mKey;

        private TintTransformation(@ColorInt int color, @NonNull PorterDuff.Mode mode) {
            this.mColor = color;
            this.mMode = mode;
            this.mKey = "_tint_" + color + "_" + mode;
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.tint(bitmap, this.mColor, this.mMode);
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class GrayScaleTransformation
    implements BitmapTransformation {
        private GrayScaleTransformation() {
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.convertToGrayScale(bitmap);
        }

        @Override
        @NonNull
        public String getKey() {
            return "_gray_scale";
        }
    }

    private static final class InvertColorsTransformation
    implements BitmapTransformation {
        private InvertColorsTransformation() {
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Bitmap bitmap) throws Throwable {
            return ImageUtils.invertColors(bitmap);
        }

        @Override
        @NonNull
        public String getKey() {
            return "_invert_colors";
        }
    }
}

