/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.media.ExifInterface;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.ImageUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;
import java.io.InputStream;

final class UriBitmapLoader
implements BitmapLoader<Uri> {
    UriBitmapLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull Context context, @NonNull Uri data, @Nullable Size size) throws Throwable {
        Bitmap bitmap;
        if (size != null) {
            bitmap = DataUtils.loadSampledBitmapFromUri(context, data, size.getWidth(), size.getHeight());
        } else {
            InputStream inputStream = null;
            try {
                inputStream = InternalUtils.getDataStreamFromUri(context, data);
                if (inputStream == null) {
                    Bitmap bitmap2 = null;
                    return bitmap2;
                }
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            }
            finally {
                InternalUtils.close(inputStream);
            }
        }
        if (bitmap != null && InternalUtils.isUriLocal(data)) {
            int rotation = 0;
            InputStream inputStream = null;
            try {
                inputStream = context.getContentResolver().openInputStream(data);
                if (inputStream != null) {
                    rotation = InternalUtils.getExifRotation(new ExifInterface(inputStream));
                }
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
            if (rotation != 0) {
                Bitmap rotated = ImageUtils.rotate(bitmap, rotation);
                if (rotated != bitmap) {
                    bitmap.recycle();
                }
                bitmap = rotated;
            }
        }
        return bitmap;
    }
}

