/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapLoaderHolder;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.ImageLoaderHolder;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadImageRequest;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.StorageImageCache;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class ImageLoader {
    private final PauseLock mPauseLock = new PauseLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final ExecutorService mExecutor;

    private ImageLoader(@NonNull Context context, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable ExecutorService executor) {
        this.mContext = context;
        this.mMainThreadHandler = new Handler(context.getMainLooper());
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mExecutor = executor != null ? executor : new ImageLoaderExecutor(InternalUtils.getPoolSize());
        if (storageCache instanceof StorageImageCache) {
            ((StorageImageCache)storageCache).setExecutor(this.mExecutor);
        }
    }

    @NonNull
    public <T> LoadImageRequest<T> request(@NonNull BitmapLoader<T> loader) {
        return new LoadImageRequest<T>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, loader);
    }

    @NonNull
    public DataTypeSelector request() {
        return new DataTypeSelector(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache);
    }

    public void invalidate(@NonNull DataDescriptor<?> descriptor) {
        ImageCache storageCache;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.remove(key);
        }
        if ((storageCache = this.mStorageCache) != null) {
            storageCache.remove(key);
        }
    }

    public boolean isLoadingPaused() {
        return this.mPauseLock.isPaused();
    }

    public void setPauseLoading(boolean paused) {
        this.mPauseLock.setPaused(paused);
    }

    public void setInterruptLoadingEarly(boolean interrupt) {
        this.mPauseLock.setInterruptEarly(interrupt);
    }

    public void clearMemoryCache() {
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.clear();
        }
    }

    public void clearStorageCache() {
        ImageCache storageCache = this.mStorageCache;
        if (storageCache != null) {
            storageCache.clear();
        }
    }

    public void clearAllCaches() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    @NonNull
    public static ImageLoader with(@NonNull Context context) {
        return ImageLoaderHolder.get(context);
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private final Context mContext;
        private ImageCache mMemoryCache;
        private ImageCache mStorageCache;
        private ExecutorService mExecutor;

        private Builder(@NonNull Context context) {
            this.mContext = context;
        }

        @NonNull
        public Builder memoryCache() {
            this.mMemoryCache = new MemoryImageCache();
            return this;
        }

        @NonNull
        public Builder memoryCache(int maxSize) {
            this.mMemoryCache = new MemoryImageCache(maxSize);
            return this;
        }

        @NonNull
        public Builder memoryCache(@Nullable ImageCache memoryCache) {
            this.mMemoryCache = memoryCache;
            return this;
        }

        @NonNull
        public Builder storageCache() {
            this.mStorageCache = new StorageImageCache(this.mContext);
            return this;
        }

        @NonNull
        public Builder storageCache(long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, maxSize);
            return this;
        }

        @NonNull
        public Builder storageCache(@NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder storageCache(@NonNull File directory) {
            this.mStorageCache = new StorageImageCache(directory);
            return this;
        }

        @NonNull
        public Builder storageCache(@NonNull File directory, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, maxSize);
            return this;
        }

        @NonNull
        public Builder storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder storageCache(@Nullable ImageCache storageCache) {
            this.mStorageCache = storageCache;
            return this;
        }

        @NonNull
        public Builder executor(@Nullable ExecutorService executor) {
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public ImageLoader build() {
            return new ImageLoader(this.mContext, this.mMemoryCache, this.mStorageCache, this.mExecutor);
        }
    }

    public static final class DataTypeSelector {
        private final Context mContext;
        private final ExecutorService mExecutor;
        private final PauseLock mPauseLock;
        private final Handler mMainThreadHandler;
        private final ImageCache mMemoryCache;
        private final ImageCache mStorageCache;

        private DataTypeSelector(@NonNull Context context, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, @NonNull ImageCache memoryCache, @NonNull ImageCache storageCache) {
            this.mContext = context;
            this.mExecutor = executor;
            this.mPauseLock = pauseLock;
            this.mMainThreadHandler = mainThreadHandler;
            this.mMemoryCache = memoryCache;
            this.mStorageCache = storageCache;
        }

        @NonNull
        public LoadImageRequest<Uri> uri() {
            return new LoadImageRequest<Uri>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.uri());
        }

        @NonNull
        public LoadImageRequest<String> url() {
            return new LoadImageRequest<String>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.url());
        }

        @NonNull
        public LoadImageRequest<File> file() {
            return new LoadImageRequest<File>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.file());
        }

        @NonNull
        public LoadImageRequest<FileDescriptor> fileDescriptor() {
            return new LoadImageRequest<FileDescriptor>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.fileDescriptor());
        }

        @NonNull
        public LoadImageRequest<Integer> resource() {
            return new LoadImageRequest<Integer>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.resource());
        }

        @NonNull
        public LoadImageRequest<byte[]> byteArray() {
            return new LoadImageRequest<byte[]>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, BitmapLoaderHolder.byteArray());
        }
    }
}

