/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class SynchronousExecutor
extends AbstractExecutorService {
    private static final Lock INSTANCE_LOCK = new ReentrantLock();
    private static volatile ExecutorService sInstance;

    private SynchronousExecutor() {
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("shutdown");
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("shutdownNow");
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("awaitTermination");
    }

    @Override
    public void execute(@NonNull Runnable command) {
        Throwable thrown = null;
        try {
            command.run();
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            this.afterExecute(command, thrown);
        }
    }

    private void afterExecute(@NonNull Runnable r, @Nullable Throwable t) {
        Future f;
        if (t == null && r instanceof Future && (f = (Future)((Object)r)).isDone()) {
            try {
                f.get();
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @NonNull
    public static ExecutorService get() {
        ExecutorService instance = sInstance;
        if (instance == null) {
            INSTANCE_LOCK.lock();
            try {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new SynchronousExecutor();
                }
            }
            finally {
                INSTANCE_LOCK.unlock();
            }
        }
        return instance;
    }
}

