/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.ByteBuffer;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class StorageImageCache
implements ImageCache {
    public static final String DEFAULT_DIRECTORY = "image_loader_cache";
    public static final long DEFAULT_MAX_SIZE = 0x3200000L;
    private final Lock mTrimLock = new ReentrantLock();
    private final Callable<?> mTrimTask = new TrimTask();
    private final FileFilter mFileFilter = new CacheFileFilter();
    private final Comparator<File> mFileComparator = new FileComparator();
    private final CompressMode mCompressMode;
    private final File mDirectory;
    private final long mMaxSize;
    private volatile ExecutorService mExecutor;
    private volatile boolean mTrimming;
    private volatile boolean mTrimRequested;

    public StorageImageCache(@NonNull Context context) {
        this(StorageImageCache.getDefaultDirectory(context));
    }

    public StorageImageCache(@NonNull Context context, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), maxSize);
    }

    public StorageImageCache(@NonNull Context context, @NonNull CompressMode compressMode, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), compressMode, maxSize);
    }

    public StorageImageCache(@NonNull File directory) {
        this(directory, 0x3200000L);
    }

    public StorageImageCache(@NonNull File directory, long maxSize) {
        this(directory, CompressMode.LOSSLESS, maxSize);
    }

    public StorageImageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mDirectory = directory;
        this.mCompressMode = compressMode;
        this.mMaxSize = maxSize;
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void setExecutor(@Nullable ExecutorService executor) {
        if (this.mExecutor != null) {
            return;
        }
        this.mExecutor = executor;
    }

    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        Bitmap bitmap = InternalUtils.decodeBitmap(file);
        if (bitmap != null) {
            file.setLastModified(System.currentTimeMillis());
            return bitmap;
        }
        file.delete();
        return null;
    }

    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        File file = this.getFile(key);
        if (file.exists()) {
            file.delete();
        }
        ByteBuffer outputBuffer = InternalUtils.byteBuffer();
        if (value.compress(this.mCompressMode.getFormat(), this.mCompressMode.getQuality(), (OutputStream)outputBuffer)) {
            if (InternalUtils.writeBytes(file, outputBuffer.getArray(), outputBuffer.getSize())) {
                this.trim();
            } else {
                file.delete();
            }
        }
    }

    @Override
    public void remove(@NonNull String key) {
        File file = this.getFile(key);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void clear() {
        File[] files = this.getFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    @NonNull
    private File getFile(@NonNull String key) {
        return new File(this.mDirectory, key);
    }

    @Nullable
    private File[] getFiles() {
        return this.mDirectory.listFiles(this.mFileFilter);
    }

    private void trim() {
        ExecutorService executor = this.mExecutor;
        if (executor == null) {
            return;
        }
        this.mTrimLock.lock();
        try {
            if (this.mTrimming) {
                this.mTrimRequested = true;
            } else {
                this.mTrimming = true;
                executor.submit(this.mTrimTask);
            }
        }
        finally {
            this.mTrimLock.unlock();
        }
    }

    @NonNull
    private static File getDefaultDirectory(@NonNull Context context) {
        File directory = context.getExternalCacheDir();
        if (directory == null) {
            directory = context.getCacheDir();
        }
        return new File(directory, DEFAULT_DIRECTORY);
    }

    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(@NonNull File lhs, @NonNull File rhs) {
            return Long.signum(rhs.lastModified() - lhs.lastModified());
        }
    }

    private static final class CacheFileFilter
    implements FileFilter {
        private CacheFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }

    private final class TrimTask
    implements Callable<Void> {
        private TrimTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            while (true) {
                try {
                    File[] files = StorageImageCache.this.getFiles();
                    if (files != null && files.length != 0) {
                        Arrays.sort(files, StorageImageCache.this.mFileComparator);
                        long size = 0L;
                        boolean removing = false;
                        for (File cached : files) {
                            if (removing) {
                                cached.delete();
                                continue;
                            }
                            if ((size += cached.length()) < StorageImageCache.this.mMaxSize) continue;
                            removing = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StorageImageCache.this.mTrimLock.lock();
                try {
                    if (!StorageImageCache.this.mTrimRequested) {
                        StorageImageCache.this.mTrimming = false;
                        break;
                    }
                    StorageImageCache.this.mTrimRequested = false;
                    continue;
                }
                finally {
                    StorageImageCache.this.mTrimLock.unlock();
                    continue;
                }
                break;
            }
            return null;
        }
    }
}

