/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import com.budiyev.android.imageloader.ByteBuffer;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

final class InternalUtils {
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int BUFFER_SIZE = 16384;
    private static final int MAX_POOL_SIZE = 4;
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private static final String URI_SCHEME_FTP = "ftp";

    private InternalUtils() {
    }

    @NonNull
    public static ByteBuffer byteBuffer() {
        return new ByteBuffer(16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Bitmap decodeBitmap(@NonNull File file) {
        Bitmap bitmap;
        FileInputStream inputStream = null;
        try {
            int read;
            inputStream = new FileInputStream(file);
            ByteBuffer outputBuffer = InternalUtils.byteBuffer();
            byte[] buffer = new byte[16384];
            while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputBuffer.write(buffer, 0, read);
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])outputBuffer.getArray(), (int)0, (int)outputBuffer.getSize());
        }
        catch (IOException e) {
            Bitmap bitmap2;
            try {
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
            return bitmap2;
        }
        InternalUtils.close(inputStream);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytes(@NonNull File file, byte[] bytes, int length) {
        boolean bl;
        FileOutputStream output = null;
        try {
            int write;
            output = new FileOutputStream(file);
            for (int remaining = length; remaining > 0; remaining -= write) {
                write = Math.min(remaining, 16384);
                output.write(bytes, length - remaining, write);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                InternalUtils.close(output);
                throw throwable;
            }
            InternalUtils.close(output);
            return bl2;
        }
        InternalUtils.close(output);
        return bl;
    }

    @Nullable
    @MainThread
    public static DisplayImageAction<?> getDisplayImageAction(@Nullable View view) {
        Drawable drawable;
        if (view != null && (drawable = InternalUtils.getDrawable(view)) instanceof PlaceholderDrawable) {
            return ((PlaceholderDrawable)drawable).getAction();
        }
        return null;
    }

    @Nullable
    public static InputStream getDataStreamFromUri(@NonNull Context context, @NonNull Uri uri) throws IOException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_HTTP.equalsIgnoreCase(scheme) || URI_SCHEME_HTTPS.equalsIgnoreCase(scheme) || URI_SCHEME_FTP.equalsIgnoreCase(scheme)) {
            URLConnection connection = new URL(uri.toString()).openConnection();
            connection.setConnectTimeout(10000);
            return connection.getInputStream();
        }
        return context.getContentResolver().openInputStream(uri);
    }

    @Nullable
    public static InputStream getDataStreamFromUrl(@NonNull String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(10000);
        return connection.getInputStream();
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDrawable(@NonNull Drawable drawable, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static void setBitmap(@NonNull Resources resources, @NonNull Bitmap bitmap, @NonNull View view) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageBitmap(bitmap);
        } else {
            BitmapDrawable drawable = new BitmapDrawable(resources, bitmap);
            if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground((Drawable)drawable);
            } else {
                view.setBackgroundDrawable((Drawable)drawable);
            }
        }
    }

    @Nullable
    public static Drawable getDrawable(@NonNull View view) {
        if (view instanceof ImageView) {
            return ((ImageView)view).getDrawable();
        }
        return view.getBackground();
    }

    public static int getPoolSize() {
        return Math.min(Runtime.getRuntime().availableProcessors(), 4);
    }
}

