/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.LruCache;
import com.budiyev.android.imageloader.ImageCache;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class MemoryImageCache
implements ImageCache {
    private static final float DEFAULT_MEMORY_FRACTION = 0.25f;
    private final LruCache<String, Bitmap> mCache;
    private final Set<String> mKeySet = Collections.newSetFromMap(new ConcurrentHashMap());

    public MemoryImageCache() {
        this(Math.round((float)Runtime.getRuntime().maxMemory() * 0.25f));
    }

    public MemoryImageCache(int maxSize) {
        this.mCache = new CacheImpl(maxSize);
    }

    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        return (Bitmap)this.mCache.get((Object)key);
    }

    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        this.mCache.put((Object)key, (Object)value);
        this.mKeySet.add(key);
    }

    @Override
    public void remove(@NonNull String key) {
        Iterator<String> i = this.mKeySet.iterator();
        while (i.hasNext()) {
            String k = i.next();
            if (!k.startsWith(key)) continue;
            this.mCache.remove((Object)k);
            i.remove();
        }
    }

    @Override
    public void clear() {
        this.mCache.evictAll();
    }

    private final class CacheImpl
    extends LruCache<String, Bitmap> {
        public CacheImpl(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(String key, Bitmap value) {
            if (Build.VERSION.SDK_INT >= 19) {
                return value.getAllocationByteCount();
            }
            return value.getByteCount();
        }

        protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
            if (evicted) {
                MemoryImageCache.this.mKeySet.remove(key);
            }
        }
    }
}

