/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.UriBitmapLoader;
import com.budiyev.android.imageloader.UrlBitmapLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class LoaderCache {
    private static final Lock LOCK = new ReentrantLock();
    private static volatile UriBitmapLoader sUriBitmapLoader;
    private static volatile UrlBitmapLoader sUrlBitmapLoader;
    private static volatile FileBitmapLoader sFileBitmapLoader;
    private static volatile FileDescriptorBitmapLoader sFileDescriptorBitmapLoader;
    private static volatile ResourceBitmapLoader sResourceBitmapLoader;
    private static volatile ByteArrayBitmapLoader sByteArrayBitmapLoader;

    private LoaderCache() {
    }

    @NonNull
    public static UriBitmapLoader getUriBitmapLoader() {
        UriBitmapLoader loader = sUriBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sUriBitmapLoader;
                if (loader == null) {
                    sUriBitmapLoader = loader = new UriBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }

    @NonNull
    public static UrlBitmapLoader getUrlBitmapLoader() {
        UrlBitmapLoader loader = sUrlBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sUrlBitmapLoader;
                if (loader == null) {
                    sUrlBitmapLoader = loader = new UrlBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }

    @NonNull
    public static FileBitmapLoader getFileBitmapLoader() {
        FileBitmapLoader loader = sFileBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sFileBitmapLoader;
                if (loader == null) {
                    sFileBitmapLoader = loader = new FileBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }

    @NonNull
    public static FileDescriptorBitmapLoader getFileDescriptorBitmapLoader() {
        FileDescriptorBitmapLoader loader = sFileDescriptorBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sFileDescriptorBitmapLoader;
                if (loader == null) {
                    sFileDescriptorBitmapLoader = loader = new FileDescriptorBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }

    @NonNull
    public static ResourceBitmapLoader getResourceBitmapLoader() {
        ResourceBitmapLoader loader = sResourceBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sResourceBitmapLoader;
                if (loader == null) {
                    sResourceBitmapLoader = loader = new ResourceBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }

    @NonNull
    public static ByteArrayBitmapLoader getByteArrayBitmapLoader() {
        ByteArrayBitmapLoader loader = sByteArrayBitmapLoader;
        if (loader == null) {
            LOCK.lock();
            try {
                loader = sByteArrayBitmapLoader;
                if (loader == null) {
                    sByteArrayBitmapLoader = loader = new ByteArrayBitmapLoader();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return loader;
    }
}

