/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.budiyev.android.imageloader.BaseLoadImageAction;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.RoundedDrawable;
import java.lang.ref.WeakReference;

final class DisplayImageAction<T>
extends BaseLoadImageAction<T> {
    private final Handler mMainThreadHandler;
    private final BitmapTransformation mTransformation;
    private final DisplayCallback<T> mDisplayCallback;
    private final WeakReference<View> mView;
    private final Drawable mPlaceholder;
    private final Drawable mErrorDrawable;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;
    private final float mCornerRadius;

    public DisplayImageAction(@NonNull Context context, @NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapTransformation transformation, @NonNull Drawable placeholder, @Nullable Drawable errorDrawable, @NonNull View view, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback, @Nullable DisplayCallback<T> displayCallback, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, boolean fadeEnabled, long fadeDuration, float cornerRadius) {
        super(context, descriptor, bitmapLoader, memoryCache, storageCache, loadCallback, errorCallback, pauseLock);
        this.mTransformation = transformation;
        this.mDisplayCallback = displayCallback;
        this.mView = new WeakReference<View>(view);
        this.mPlaceholder = placeholder;
        this.mErrorDrawable = errorDrawable;
        this.mMainThreadHandler = mainThreadHandler;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
        this.mCornerRadius = cornerRadius;
    }

    public boolean hasSameDescriptor(@NonNull String descriptorKey) {
        return this.getDescriptor().getKey().equals(descriptorKey);
    }

    @Override
    protected void onImageLoaded(@NonNull Bitmap image) {
        DataDescriptor descriptor = this.getDescriptor();
        BitmapTransformation transformation = this.mTransformation;
        if (transformation != null) {
            Context context = this.getContext();
            Object data = descriptor.getData();
            try {
                image = transformation.transform(context, image);
            }
            catch (Throwable error) {
                this.processError(context, data, error);
                return;
            }
            ImageCache memoryCache = this.getMemoryCache();
            if (memoryCache != null) {
                memoryCache.put(descriptor.getKey() + transformation.getKey(), image);
            }
        }
        if (this.isCancelled() || this.mView.get() == null) {
            return;
        }
        this.mMainThreadHandler.post((Runnable)new SetImageAction(image));
    }

    @Override
    protected void onError(@NonNull Throwable error) {
        if (this.mErrorDrawable != null || !this.isCancelled()) {
            this.mMainThreadHandler.post((Runnable)new SetErrorDrawableAction());
        }
    }

    @Override
    protected void onCancelled() {
        this.mView.clear();
    }

    private static final class FadeCallback<T>
    implements FadeDrawable.FadeCallback {
        private final Context mContext;
        private final DisplayCallback<T> mDisplayCallback;
        private final T mData;
        private final Bitmap mImage;
        private final View mView;

        private FadeCallback(@NonNull Context context, @NonNull DisplayCallback<T> displayCallback, @NonNull T data, @NonNull Bitmap image, @NonNull View view) {
            this.mContext = context;
            this.mDisplayCallback = displayCallback;
            this.mData = data;
            this.mImage = image;
            this.mView = view;
        }

        @Override
        public void onDone() {
            this.mDisplayCallback.onDisplayed(this.mContext, this.mData, this.mImage, this.mView);
        }
    }

    private final class SetImageAction
    implements Runnable {
        private final Bitmap mImage;

        public SetImageAction(Bitmap image) {
            this.mImage = image;
        }

        @Override
        @MainThread
        public void run() {
            boolean roundCorners;
            if (DisplayImageAction.this.isCancelled()) {
                return;
            }
            View view = (View)DisplayImageAction.this.mView.get();
            if (view == null || InternalUtils.getDisplayImageAction(view) != DisplayImageAction.this) {
                return;
            }
            Bitmap image = this.mImage;
            Context context = DisplayImageAction.this.getContext();
            Resources resources = context.getResources();
            Object data = DisplayImageAction.this.getDescriptor().getData();
            DisplayCallback displayCallback = DisplayImageAction.this.mDisplayCallback;
            float cornerRadius = DisplayImageAction.this.mCornerRadius;
            boolean bl = roundCorners = cornerRadius > 0.0f || cornerRadius == -1.0f;
            if (DisplayImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                InternalUtils.setDrawable((Drawable)new FadeDrawable(DisplayImageAction.this.mPlaceholder, roundCorners ? new RoundedDrawable(resources, image, cornerRadius) : new BitmapDrawable(resources, image), DisplayImageAction.this.mFadeDuration, DisplayImageAction.this.mMainThreadHandler, displayCallback == null ? null : new FadeCallback(context, displayCallback, data, image, view)), view);
            } else {
                if (roundCorners) {
                    InternalUtils.setDrawable(new RoundedDrawable(resources, image, cornerRadius), view);
                } else {
                    InternalUtils.setBitmap(resources, image, view);
                }
                if (displayCallback != null) {
                    displayCallback.onDisplayed(context, data, image, view);
                }
            }
        }
    }

    private final class SetErrorDrawableAction
    implements Runnable {
        private SetErrorDrawableAction() {
        }

        @Override
        public void run() {
            Drawable errorDrawable = DisplayImageAction.this.mErrorDrawable;
            View view = (View)DisplayImageAction.this.mView.get();
            if (DisplayImageAction.this.isCancelled() || errorDrawable == null || view == null || InternalUtils.getDisplayImageAction(view) != DisplayImageAction.this) {
                return;
            }
            if (DisplayImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                InternalUtils.setDrawable((Drawable)new FadeDrawable(DisplayImageAction.this.mPlaceholder, errorDrawable, DisplayImageAction.this.mFadeDuration, DisplayImageAction.this.mMainThreadHandler, null), view);
            } else {
                InternalUtils.setDrawable(errorDrawable, view);
            }
        }
    }
}

