/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.Size;

final class StringDataDescriptor<T>
implements DataDescriptor<T> {
    private final T mData;
    private final String mKey;
    private final Size mSize;

    public StringDataDescriptor(@NonNull T data, @Nullable Size size) {
        this.mData = data;
        String hash = DataUtils.generateSHA256(data.toString());
        this.mKey = size != null ? hash + "_sampled_" + size : hash;
        this.mSize = size;
    }

    @Override
    @NonNull
    public T getData() {
        return this.mData;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }

    @Override
    @Nullable
    public Size getRequiredSize() {
        return this.mSize;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof StringDataDescriptor && this.mKey.equals(((StringDataDescriptor)obj).mKey);
    }

    @NonNull
    public String toString() {
        return "DataDescriptor [key: " + this.mKey + ", data: " + this.mData + "]";
    }
}

