/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.view.View;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.BitmapTransformationGroup;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.RoundedDrawable;
import com.budiyev.android.imageloader.Size;
import com.budiyev.android.imageloader.StringDataDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class LoadImageRequest<T> {
    private final Context mContext;
    private final ExecutorService mExecutor;
    private final PauseLock mPauseLock;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final BitmapLoader<T> mBitmapLoader;
    private final Handler mMainThreadHandler;
    private T mData;
    private Size mRequiredSize;
    private DataDescriptor<T> mDescriptor;
    private LoadCallback<T> mLoadCallback;
    private ErrorCallback<T> mErrorCallback;
    private DisplayCallback<T> mDisplayCallback;
    private List<BitmapTransformation> mTransformations;
    private Drawable mPlaceholder;
    private Drawable mErrorDrawable;
    private boolean mFadeEnabled = true;
    private long mFadeDuration = 200L;
    private float mCornerRadius;

    LoadImageRequest(@NonNull Context context, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @NonNull BitmapLoader<T> bitmapLoader) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mBitmapLoader = bitmapLoader;
        this.mMainThreadHandler = mainThreadHandler;
    }

    @NonNull
    public LoadImageRequest<T> from(@NonNull T data) {
        this.mDescriptor = null;
        this.mData = data;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> size(@Px int requiredWidth, @Px int requiredHeight) {
        this.mDescriptor = null;
        this.mRequiredSize = new Size(requiredWidth, requiredHeight);
        return this;
    }

    @NonNull
    public LoadImageRequest<T> from(@Nullable DataDescriptor<T> descriptor) {
        this.mData = null;
        this.mRequiredSize = null;
        this.mDescriptor = descriptor;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> roundCorners() {
        this.mCornerRadius = -1.0f;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> roundCorners(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> placeholder(@Nullable Drawable placeholder) {
        this.mPlaceholder = placeholder;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> errorDrawable(@Nullable Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> transform(@NonNull BitmapTransformation transformation) {
        List<BitmapTransformation> transformations = this.mTransformations;
        if (transformations == null) {
            this.mTransformations = transformations = new ArrayList<BitmapTransformation>();
        }
        transformations.add(transformation);
        return this;
    }

    @NonNull
    public LoadImageRequest<T> fade() {
        this.mFadeEnabled = true;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> noFade() {
        this.mFadeEnabled = false;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> fade(long duration) {
        this.mFadeEnabled = true;
        this.mFadeDuration = duration;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> onLoaded(@Nullable LoadCallback<T> callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> onError(@Nullable ErrorCallback<T> callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest<T> onDisplayed(@Nullable DisplayCallback<T> callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @AnyThread
    public void load() {
        DataDescriptor<T> descriptor = this.getDescriptor();
        if (descriptor == null) {
            return;
        }
        new LoadImageAction<T>(this.mContext, descriptor, this.mBitmapLoader, this.mMemoryCache, this.mStorageCache, this.mLoadCallback, this.mErrorCallback, this.mPauseLock).execute(this.mExecutor);
    }

    @MainThread
    public void load(@NonNull View view) {
        Drawable placeholder;
        DataDescriptor<T> descriptor = this.getDescriptor();
        if (descriptor == null) {
            return;
        }
        Bitmap image = null;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        List<BitmapTransformation> transformations = this.mTransformations;
        BitmapTransformation transformation = transformations != null && !transformations.isEmpty() ? (transformations.size() == 1 ? transformations.get(0) : new BitmapTransformationGroup(transformations)) : null;
        if (memoryCache != null) {
            image = transformation != null ? memoryCache.get(key + transformation.getKey()) : memoryCache.get(key);
        }
        T data = descriptor.getData();
        Context context = this.mContext;
        LoadCallback<T> loadCallback = this.mLoadCallback;
        DisplayCallback<T> displayCallback = this.mDisplayCallback;
        float cornerRadius = this.mCornerRadius;
        if (image != null) {
            if (loadCallback != null) {
                loadCallback.onLoaded(context, data, image);
            }
            Resources resources = context.getResources();
            if (cornerRadius > 0.0f || cornerRadius == -1.0f) {
                InternalUtils.setDrawable(new RoundedDrawable(resources, image, cornerRadius), view);
            } else {
                InternalUtils.setBitmap(resources, image, view);
            }
            if (displayCallback != null) {
                displayCallback.onDisplayed(context, data, image, view);
            }
            return;
        }
        DisplayImageAction<?> currentAction = InternalUtils.getDisplayImageAction(view);
        if (currentAction != null) {
            if (currentAction.hasSameDescriptor(key)) {
                return;
            }
            currentAction.cancel();
        }
        if ((placeholder = this.mPlaceholder) == null) {
            placeholder = new ColorDrawable(0);
        }
        DisplayImageAction<T> action = new DisplayImageAction<T>(context, descriptor, this.mBitmapLoader, transformation, placeholder, this.mErrorDrawable, view, memoryCache, this.mStorageCache, loadCallback, this.mErrorCallback, displayCallback, this.mPauseLock, this.mMainThreadHandler, this.mFadeEnabled, this.mFadeDuration, cornerRadius);
        InternalUtils.setDrawable((Drawable)new PlaceholderDrawable(placeholder, action), view);
        action.execute(this.mExecutor);
    }

    @Nullable
    private DataDescriptor<T> getDescriptor() {
        DataDescriptor<T> descriptor = this.mDescriptor;
        if (descriptor != null) {
            return descriptor;
        }
        T data = this.mData;
        if (data != null) {
            return new StringDataDescriptor<T>(data, this.mRequiredSize);
        }
        return null;
    }
}

