/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.BitmapTransformationGroup;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ErrorDrawableProvider;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PlaceholderProvider;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class LoadImageRequestInternal {
    private static final Lock LOADER_LOCK = new ReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ImageLoader<Uri> sLoader;
    private final Context mContext;
    private final Uri mData;
    private final ImageView mView;
    private final PlaceholderProvider<Uri> mPlaceholder;
    private final ErrorDrawableProvider<Uri> mErrorDrawable;
    private final BitmapTransformation<Uri> mTransformation;
    private final LoadCallback<Uri> mLoadCallback;
    private final DisplayCallback<Uri> mDisplayCallback;
    private final ErrorCallback<Uri> mErrorCallback;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;

    public LoadImageRequestInternal(@NonNull Context context, @NonNull Uri data, @Nullable ImageView view, @Nullable Drawable placeholder, @Nullable Drawable errorDrawable, @Nullable List<BitmapTransformation<Uri>> transformations, @Nullable LoadCallback<Uri> loadCallback, @Nullable DisplayCallback<Uri> displayCallback, @Nullable ErrorCallback<Uri> errorCallback, boolean fadeEnabled, long fadeDuration) {
        this.mContext = context.getApplicationContext();
        this.mData = data;
        this.mView = view;
        this.mPlaceholder = placeholder != null ? new PlaceholderWrapper(placeholder) : null;
        this.mErrorDrawable = errorDrawable != null ? new ErrorDrawableWrapper(errorDrawable) : null;
        this.mTransformation = transformations != null && !transformations.isEmpty() ? (transformations.size() == 1 ? transformations.get(0) : new BitmapTransformationGroup<Uri>(transformations)) : null;
        this.mLoadCallback = loadCallback;
        this.mDisplayCallback = displayCallback;
        this.mErrorCallback = errorCallback;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
    }

    @AnyThread
    public void execute() {
        DataDescriptor<Uri> descriptor = DataUtils.descriptor(this.mData);
        ImageLoader<Uri> loader = this.getLoader();
        if (this.mView == null) {
            loader.load(descriptor, this.mLoadCallback, this.mErrorCallback);
        } else {
            loader.runOnMainThread(new LoadAction(loader, descriptor, this.mView, this.mPlaceholder, this.mErrorDrawable, this.mTransformation, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback, this.mFadeEnabled, this.mFadeDuration));
        }
    }

    @NonNull
    private ImageLoader<Uri> getLoader() {
        ImageLoader<Uri> loader = sLoader;
        if (loader == null) {
            LOADER_LOCK.lock();
            try {
                loader = sLoader;
                if (loader == null) {
                    loader = ImageLoader.builder(this.mContext).uri().memoryCache().storageCache().build();
                    this.mContext.registerComponentCallbacks((ComponentCallbacks)new ClearMemoryCacheCallbacks());
                    sLoader = loader;
                }
            }
            finally {
                LOADER_LOCK.unlock();
            }
        }
        return loader;
    }

    private static final class ErrorDrawableWrapper
    implements ErrorDrawableProvider<Uri> {
        private final Drawable mDrawable;

        public ErrorDrawableWrapper(@NonNull Drawable drawable) {
            this.mDrawable = drawable;
        }

        @Override
        @NonNull
        public Drawable getErrorDrawable(@NonNull Context context, @NonNull Uri data) {
            return this.mDrawable;
        }
    }

    private static final class PlaceholderWrapper
    implements PlaceholderProvider<Uri> {
        private final Drawable mDrawable;

        public PlaceholderWrapper(@NonNull Drawable drawable) {
            this.mDrawable = drawable;
        }

        @Override
        @NonNull
        public Drawable getPlaceholder(@NonNull Context context, @NonNull Uri data) {
            return this.mDrawable;
        }
    }

    private static final class ClearMemoryCacheCallbacks
    implements ComponentCallbacks2 {
        private ClearMemoryCacheCallbacks() {
        }

        public void onTrimMemory(int level) {
            ImageLoader loader;
            if (level >= 40 && (loader = sLoader) != null) {
                loader.clearMemoryCache();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            ImageLoader loader = sLoader;
            if (loader != null) {
                loader.clearMemoryCache();
            }
        }
    }

    private static final class LoadAction
    implements Runnable {
        private final ImageLoader<Uri> mLoader;
        private final DataDescriptor<Uri> mDescriptor;
        private final ImageView mView;
        private final PlaceholderProvider<Uri> mPlaceholder;
        private final ErrorDrawableProvider<Uri> mErrorDrawable;
        private final BitmapTransformation<Uri> mTransformation;
        private final LoadCallback<Uri> mLoadCallback;
        private final DisplayCallback<Uri> mDisplayCallback;
        private final ErrorCallback<Uri> mErrorCallback;
        private final boolean mFadeEnabled;
        private final long mFadeDuration;

        public LoadAction(@NonNull ImageLoader<Uri> loader, @NonNull DataDescriptor<Uri> descriptor, @NonNull ImageView view, @Nullable PlaceholderProvider<Uri> placeholder, @Nullable ErrorDrawableProvider<Uri> errorDrawable, @Nullable BitmapTransformation<Uri> transformation, @Nullable LoadCallback<Uri> loadCallback, @Nullable DisplayCallback<Uri> displayCallback, @Nullable ErrorCallback<Uri> errorCallback, boolean fadeEnabled, long fadeDuration) {
            this.mLoader = loader;
            this.mDescriptor = descriptor;
            this.mView = view;
            this.mPlaceholder = placeholder;
            this.mErrorDrawable = errorDrawable;
            this.mTransformation = transformation;
            this.mLoadCallback = loadCallback;
            this.mDisplayCallback = displayCallback;
            this.mErrorCallback = errorCallback;
            this.mFadeEnabled = fadeEnabled;
            this.mFadeDuration = fadeDuration;
        }

        @Override
        @MainThread
        public void run() {
            this.mLoader.load(this.mDescriptor, this.mView, this.mPlaceholder, this.mErrorDrawable, this.mTransformation, this.mLoadCallback, this.mErrorCallback, this.mDisplayCallback, this.mFadeEnabled, this.mFadeDuration);
        }
    }
}

