/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.BitmapTransformation;
import java.util.List;

final class BitmapTransformationGroup<T>
implements BitmapTransformation<T> {
    private final List<BitmapTransformation<T>> mTransformations;
    private final String mKey;

    public BitmapTransformationGroup(@NonNull List<BitmapTransformation<T>> transformations) {
        this.mTransformations = transformations;
        StringBuilder sb = new StringBuilder();
        for (BitmapTransformation<T> t : transformations) {
            sb.append(t.getKey());
        }
        this.mKey = sb.toString();
    }

    @Override
    @NonNull
    public Bitmap transform(@NonNull Context context, @NonNull T data, @NonNull Bitmap bitmap) throws Throwable {
        boolean first = true;
        for (BitmapTransformation<T> transformation : this.mTransformations) {
            Bitmap processed = transformation.transform(context, data, bitmap);
            if (bitmap != processed) {
                if (!first && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                first = false;
            }
            bitmap = processed;
        }
        return bitmap;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }
}

