/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class PauseLock {
    private final Lock mLock = new ReentrantLock();
    private final Condition mCondition = this.mLock.newCondition();
    private volatile boolean mPaused;

    PauseLock() {
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public void setPaused(boolean paused) {
        this.mLock.lock();
        try {
            this.mPaused = paused;
            if (!paused) {
                this.mCondition.signalAll();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean await() {
        boolean interrupted = false;
        this.mLock.lock();
        try {
            if (this.mPaused) {
                this.mCondition.await();
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        finally {
            this.mLock.unlock();
        }
        return interrupted;
    }
}

