/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;

@RequiresApi(value=19)
final class FadeDrawable
extends LayerDrawable {
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 3;
    private static final int START_DRAWABLE = 0;
    private static final int END_DRAWABLE = 1;
    private final Handler mMainThreadHandler;
    private final FadeCallback mFadeCallback;
    private final long mFadeDuration;
    private final int mStartAlpha;
    private final int mEndAlpha;
    private long mStartTime;
    private int mFadeState = 0;

    public FadeDrawable(@NonNull Drawable startDrawable, @NonNull Drawable endDrawable, long fadeDuration, @NonNull Handler mainThreadHandler, @Nullable FadeCallback fadeCallback) {
        super(new Drawable[]{startDrawable, endDrawable});
        this.mMainThreadHandler = mainThreadHandler;
        this.mFadeDuration = fadeDuration;
        this.mFadeCallback = fadeCallback;
        this.mStartAlpha = startDrawable.getAlpha();
        this.mEndAlpha = endDrawable.getAlpha();
    }

    public void draw(Canvas canvas) {
        switch (this.mFadeState) {
            case 0: {
                this.getDrawable(0).draw(canvas);
                this.mStartTime = SystemClock.uptimeMillis();
                this.mFadeState = 1;
                this.invalidateSelf();
                break;
            }
            case 1: {
                long elapsed = SystemClock.uptimeMillis() - this.mStartTime;
                int startAlpha = this.mStartAlpha - (int)((long)this.mStartAlpha * elapsed / this.mFadeDuration);
                int endAlpha = (int)((long)this.mEndAlpha * elapsed / this.mFadeDuration);
                Drawable startDrawable = this.getDrawable(0);
                Drawable endDrawable = this.getDrawable(1);
                if (startAlpha <= 0 || endAlpha >= this.mEndAlpha) {
                    this.mFadeState = 3;
                    endDrawable.setAlpha(this.mEndAlpha);
                    endDrawable.draw(canvas);
                    FadeCallback fadeCallback = this.mFadeCallback;
                    if (fadeCallback == null) break;
                    this.mMainThreadHandler.post((Runnable)new CallbackAction(fadeCallback));
                    break;
                }
                startDrawable.setAlpha(startAlpha);
                startDrawable.draw(canvas);
                endDrawable.setAlpha(endAlpha);
                endDrawable.draw(canvas);
                this.invalidateSelf();
                break;
            }
            case 3: {
                this.getDrawable(1).draw(canvas);
            }
        }
    }

    private static final class CallbackAction
    implements Runnable {
        private final FadeCallback mCallback;

        private CallbackAction(@NonNull FadeCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void run() {
            this.mCallback.onDone();
        }
    }

    public static interface FadeCallback {
        public void onDone();
    }
}

