/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapProcessor;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.EmptyPlaceholderProvider;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.ImagePlaceholderProvider;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.PlaceholderProvider;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.StringDataDescriptor;
import com.budiyev.android.imageloader.UriBitmapLoader;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class ImageLoader<T> {
    private final PauseLock mPauseLock = new PauseLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final BitmapLoader<T> mBitmapLoader;
    private final BitmapProcessor<T> mBitmapProcessor;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final PlaceholderProvider<T> mPlaceholderProvider;
    private final ExecutorService mExecutor;
    private final LoadCallback<T> mLoadCallback;
    private final DisplayCallback<T> mDisplayCallback;
    private final ErrorCallback<T> mErrorCallback;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;

    private ImageLoader(@NonNull Context context, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapProcessor<T> bitmapProcessor, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable PlaceholderProvider<T> placeholderProvider, @Nullable ExecutorService executor, @Nullable LoadCallback<T> loadCallback, @Nullable DisplayCallback<T> displayCallback, @Nullable ErrorCallback<T> errorCallback, boolean fadeEnabled, long fadeDuration) {
        this.mContext = context;
        this.mMainThreadHandler = new Handler(context.getMainLooper());
        this.mBitmapLoader = bitmapLoader;
        this.mBitmapProcessor = bitmapProcessor;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mLoadCallback = loadCallback;
        this.mDisplayCallback = displayCallback;
        this.mErrorCallback = errorCallback;
        this.mPlaceholderProvider = placeholderProvider != null ? placeholderProvider : new EmptyPlaceholderProvider();
        this.mExecutor = executor != null ? executor : new ImageLoaderExecutor(InternalUtils.getPoolSize());
        if (storageCache instanceof StorageImageCache) {
            ((StorageImageCache)storageCache).setExecutor(this.mExecutor);
        }
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
    }

    @MainThread
    public void load(@NonNull T data, @NonNull ImageView view) {
        this.load(new StringDataDescriptor<T>(data), view, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback);
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view) {
        this.load(descriptor, view, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback);
    }

    @MainThread
    public void load(@NonNull T data, @NonNull ImageView view, @Nullable LoadCallback<T> loadCallback, @Nullable DisplayCallback<T> displayCallback, @Nullable ErrorCallback<T> errorCallback) {
        this.load(new StringDataDescriptor<T>(data), view, loadCallback, displayCallback, errorCallback);
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view, @Nullable LoadCallback<T> loadCallback, @Nullable DisplayCallback<T> displayCallback, @Nullable ErrorCallback<T> errorCallback) {
        Bitmap image = null;
        String key = descriptor.getKey();
        ImageCache memoryImageCache = this.mMemoryCache;
        if (memoryImageCache != null) {
            image = memoryImageCache.get(key);
        }
        if (image != null) {
            view.setImageBitmap(image);
            return;
        }
        LoadImageAction<?> currentAction = InternalUtils.getLoadImageAction(view);
        if (currentAction != null) {
            if (currentAction.hasSameDescriptor(key)) {
                return;
            }
            currentAction.cancel();
        }
        Context context = this.mContext;
        Drawable placeholder = this.mPlaceholderProvider.get(context, descriptor.getData());
        LoadImageAction<T> action = new LoadImageAction<T>(context, this.mMainThreadHandler, this.mExecutor, this.mPauseLock, this.mBitmapLoader, this.mBitmapProcessor, this.mMemoryCache, this.mStorageCache, loadCallback, displayCallback, errorCallback, this.mFadeEnabled, this.mFadeDuration, descriptor, view, placeholder);
        view.setImageDrawable((Drawable)new PlaceholderDrawable(placeholder, action));
        action.execute();
    }

    public void invalidate(@NonNull T data) {
        this.invalidate(new StringDataDescriptor<T>(data));
    }

    public void invalidate(@NonNull DataDescriptor<T> descriptor) {
        ImageCache storageCache;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.remove(key);
        }
        if ((storageCache = this.mStorageCache) != null) {
            storageCache.remove(key);
        }
    }

    public boolean isLoadingPaused() {
        return this.mPauseLock.isPaused();
    }

    public void setPauseLoading(boolean paused) {
        this.mPauseLock.setPaused(paused);
    }

    public void clearMemoryCache() {
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.clear();
        }
    }

    public void clearStorageCache() {
        ImageCache storageCache = this.mStorageCache;
        if (storageCache != null) {
            storageCache.clear();
        }
    }

    public void clearAllCaches() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    @NonNull
    public static BuilderSelector builder(@NonNull Context context) {
        return new BuilderSelector(context);
    }

    public static final class Builder<T> {
        private final Context mContext;
        private final BitmapLoader<T> mBitmapLoader;
        private BitmapProcessor<T> mBitmapProcessor;
        private ImageCache mMemoryCache;
        private ImageCache mStorageCache;
        private PlaceholderProvider<T> mPlaceholderProvider;
        private ExecutorService mExecutor;
        private LoadCallback<T> mLoadCallback;
        private DisplayCallback<T> mDisplayCallback;
        private ErrorCallback<T> mErrorCallback;
        private boolean mFadeEnabled = true;
        private long mFadeDuration = 200L;

        private Builder(@NonNull Context context, @NonNull BitmapLoader<T> bitmapLoader) {
            this.mContext = context;
            this.mBitmapLoader = bitmapLoader;
        }

        @NonNull
        public Builder<T> memoryCache() {
            this.mMemoryCache = new MemoryImageCache();
            return this;
        }

        @NonNull
        public Builder<T> memoryCache(int maxSize) {
            this.mMemoryCache = new MemoryImageCache(maxSize);
            return this;
        }

        @NonNull
        public Builder<T> memoryCache(@Nullable ImageCache memoryCache) {
            this.mMemoryCache = memoryCache;
            return this;
        }

        @NonNull
        public Builder<T> storageCache() {
            this.mStorageCache = new StorageImageCache(this.mContext);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory) {
            this.mStorageCache = new StorageImageCache(directory);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@Nullable ImageCache storageCache) {
            this.mStorageCache = storageCache;
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@NonNull Bitmap image) {
            this.mPlaceholderProvider = new ImagePlaceholderProvider(this.mContext.getResources(), image);
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@DrawableRes int imageRes) {
            Resources resources = this.mContext.getResources();
            Bitmap image = BitmapFactory.decodeResource((Resources)resources, (int)imageRes);
            if (image != null) {
                this.mPlaceholderProvider = new ImagePlaceholderProvider(resources, image);
            }
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@Nullable PlaceholderProvider<T> provider) {
            this.mPlaceholderProvider = provider;
            return this;
        }

        @NonNull
        public Builder<T> processor(@Nullable BitmapProcessor<T> processor) {
            this.mBitmapProcessor = processor;
            return this;
        }

        @NonNull
        public Builder<T> fade(boolean enabled, long duration) {
            this.mFadeEnabled = enabled;
            this.mFadeDuration = duration;
            return this;
        }

        @NonNull
        public Builder<T> fade(boolean enabled) {
            this.mFadeEnabled = enabled;
            return this;
        }

        @NonNull
        public Builder<T> executor(@Nullable ExecutorService executor) {
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public Builder<T> onLoaded(@Nullable LoadCallback<T> callback) {
            this.mLoadCallback = callback;
            return this;
        }

        @NonNull
        public Builder<T> onDisplayed(@Nullable DisplayCallback<T> callback) {
            this.mDisplayCallback = callback;
            return this;
        }

        @NonNull
        public Builder<T> onError(@Nullable ErrorCallback<T> callback) {
            this.mErrorCallback = callback;
            return this;
        }

        @NonNull
        public ImageLoader<T> build() {
            return new ImageLoader(this.mContext, this.mBitmapLoader, this.mBitmapProcessor, this.mMemoryCache, this.mStorageCache, this.mPlaceholderProvider, this.mExecutor, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback, this.mFadeEnabled, this.mFadeDuration);
        }
    }

    public static final class BuilderSelector {
        private final Context mContext;

        private BuilderSelector(@NonNull Context context) {
            this.mContext = context.getApplicationContext();
        }

        @NonNull
        public Builder<Uri> uri() {
            return new Builder<Uri>(this.mContext, new UriBitmapLoader());
        }

        @NonNull
        public Builder<File> file() {
            return new Builder<File>(this.mContext, new FileBitmapLoader());
        }

        @NonNull
        public Builder<FileDescriptor> fileDescriptor() {
            return new Builder<FileDescriptor>(this.mContext, new FileDescriptorBitmapLoader());
        }

        @NonNull
        public Builder<Integer> resource() {
            return new Builder<Integer>(this.mContext, new ResourceBitmapLoader());
        }

        @NonNull
        public Builder<byte[]> byteArray() {
            return new Builder<byte[]>(this.mContext, new ByteArrayBitmapLoader());
        }

        @NonNull
        public <T> Builder<T> custom(@NonNull BitmapLoader<T> bitmapLoader) {
            return new Builder(this.mContext, bitmapLoader);
        }
    }
}

