/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.LoadCallback;

final class Callbacks<T> {
    private final LoadCallback<T> mLoadCallback;
    private final ErrorCallback<T> mErrorCallback;

    public Callbacks(@Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback) {
        this.mLoadCallback = loadCallback;
        this.mErrorCallback = errorCallback;
    }

    @Nullable
    public LoadCallback<T> getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    public ErrorCallback<T> getErrorCallback() {
        return this.mErrorCallback;
    }

    @WorkerThread
    public static <T> void notifyLoaded(@Nullable Callbacks<T> callbacks, @NonNull T data, @NonNull Bitmap image) {
        if (callbacks == null) {
            return;
        }
        LoadCallback<T> callback = callbacks.mLoadCallback;
        if (callback == null) {
            return;
        }
        callback.onLoaded(data, image);
    }

    @WorkerThread
    public static <T> void notifyError(@Nullable Callbacks<T> callbacks, @NonNull T data, @NonNull Throwable error) {
        if (callbacks == null) {
            return;
        }
        ErrorCallback<T> callback = callbacks.mErrorCallback;
        if (callback == null) {
            return;
        }
        callback.onError(data, error);
    }
}

