/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class InternalUtils {
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private static final String URI_SCHEME_FTP = "ftp";
    private static final Lock LOADER_EXECUTOR_LOCK = new ReentrantLock();
    private static final Lock CACHE_EXECUTOR_LOCK = new ReentrantLock();
    private static volatile ThreadPoolExecutor sImageLoaderExecutor;
    private static volatile ThreadPoolExecutor sStorageCacheExecutor;

    private InternalUtils() {
    }

    @Nullable
    @MainThread
    public static LoadImageAction<?> getLoadImageAction(@Nullable ImageView view) {
        Drawable drawable;
        if (view != null && (drawable = view.getDrawable()) instanceof PlaceholderDrawable) {
            return ((PlaceholderDrawable)drawable).getLoadImageAction();
        }
        return null;
    }

    @Nullable
    public static InputStream getDataStreamFromUri(@NonNull Context context, @NonNull Uri uri) throws IOException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_HTTP.equalsIgnoreCase(scheme) || URI_SCHEME_HTTPS.equalsIgnoreCase(scheme) || URI_SCHEME_FTP.equalsIgnoreCase(scheme)) {
            return new URL(uri.toString()).openConnection().getInputStream();
        }
        return context.getContentResolver().openInputStream(uri);
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NonNull
    public static ThreadPoolExecutor getImageLoaderExecutor() {
        ThreadPoolExecutor executor = sImageLoaderExecutor;
        if (executor == null) {
            LOADER_EXECUTOR_LOCK.lock();
            try {
                executor = sImageLoaderExecutor;
                if (executor == null) {
                    sImageLoaderExecutor = executor = new ImageLoaderExecutor(Runtime.getRuntime().availableProcessors());
                }
            }
            finally {
                LOADER_EXECUTOR_LOCK.unlock();
            }
        }
        return executor;
    }

    @NonNull
    public static ThreadPoolExecutor getStorageCacheExecutor() {
        ThreadPoolExecutor executor = sStorageCacheExecutor;
        if (executor == null) {
            CACHE_EXECUTOR_LOCK.lock();
            try {
                executor = sStorageCacheExecutor;
                if (executor == null) {
                    sStorageCacheExecutor = executor = new ImageLoaderExecutor();
                }
            }
            finally {
                CACHE_EXECUTOR_LOCK.unlock();
            }
        }
        return executor;
    }
}

