/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.TypedValue;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class LoadUtils {
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";

    private LoadUtils() {
    }

    @NonNull
    public static String generateSHA256(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_SHA256);
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUri(@NonNull Context context, @NonNull Uri uri, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try (InputStream inputStream = InternalUtils.getDataStreamFromUri(context, uri);){
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = LoadUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = InternalUtils.getDataStreamFromUri(context, uri);
        var7_7 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var7_7 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFile(@NonNull File file, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try (FileInputStream inputStream = new FileInputStream(file);){
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = LoadUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = new FileInputStream(file);
        var6_6 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var6_6 != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFileDescriptor(@NonNull FileDescriptor fileDescriptor, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = new FileInputStream(fileDescriptor);
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = LoadUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = new FileInputStream(fileDescriptor);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromResource(@NonNull Resources resources, int resourceId, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        TypedValue typedValue = new TypedValue();
        options.inJustDecodeBounds = true;
        options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        InputStream inputStream = resources.openRawResource(resourceId, typedValue);
        if (typedValue.density == 0) {
            options.inDensity = 160;
        } else if (typedValue.density != 65535) {
            options.inDensity = typedValue.density;
        }
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = LoadUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = resources.openRawResource(resourceId, typedValue);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromByteArray(@NonNull byte[] byteArray, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
        options.inSampleSize = LoadUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    private static int calculateSampleSize(int sourceWidth, int sourceHeight, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        int sampleSize = 1;
        if (sourceWidth > requiredWidth || sourceHeight > requiredHeight) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            while (halfWidth / sampleSize > requiredWidth && halfHeight / sampleSize > requiredHeight) {
                sampleSize *= 2;
            }
            if (ignoreTotalNumberOfPixels) {
                return sampleSize;
            }
            long totalRequiredPixels = requiredWidth * requiredHeight;
            for (long totalPixels = (long)(sourceWidth * sourceHeight / (sampleSize * sampleSize)); totalPixels > totalRequiredPixels; totalPixels /= 4L) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }
}

