/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class StorageImageCache
implements ImageCache {
    public static final String DEFAULT_DIRECTORY = "image_loader_cache";
    public static final long DEFAULT_MAX_SIZE = 0x3200000L;
    private final Lock mFitLock = new ReentrantLock();
    private final Comparator<File> mFileComparator;
    private final FileFilter mFileFilter;
    private final Runnable mFitCacheSizeTask;
    private final File mDirectory;
    private final CompressMode mCompressMode;
    private final long mMaxSize;
    private volatile boolean mCacheFitting;
    private volatile boolean mCacheFitRequested;

    public StorageImageCache(@NonNull Context context) {
        this(StorageImageCache.getDefaultDirectory(context));
    }

    public StorageImageCache(@NonNull Context context, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), maxSize);
    }

    public StorageImageCache(@NonNull Context context, @NonNull CompressMode compressMode, long maxSize) {
        this(StorageImageCache.getDefaultDirectory(context), compressMode, maxSize);
    }

    public StorageImageCache(@NonNull File directory) {
        this(directory, 0x3200000L);
    }

    public StorageImageCache(@NonNull File directory, long maxSize) {
        this(directory, CompressMode.LOSSLESS, maxSize);
    }

    public StorageImageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mDirectory = directory;
        this.mCompressMode = compressMode;
        this.mMaxSize = maxSize;
        this.mFileComparator = new FileComparator();
        this.mFileFilter = new CacheFileFilter();
        this.mFitCacheSizeTask = new FitCacheSizeTask();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.fitCache();
    }

    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        block15: {
            File file = new File(this.mDirectory, key);
            if (file.exists()) {
                file.delete();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                this.mCompressMode.compress(value, outputStream);
            }
            catch (IOException e) {
                if (!file.exists()) break block15;
                file.delete();
            }
        }
        this.fitCache();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        File file = new File(this.mDirectory, key);
        file.setLastModified(System.currentTimeMillis());
        try (FileInputStream inputStream = new FileInputStream(file);){
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            return bitmap;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void remove(@NonNull String key) {
        new File(this.mDirectory, key).delete();
    }

    @Override
    public void clear() {
        File[] files = this.getCacheFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    @Nullable
    private File[] getCacheFiles() {
        return this.mDirectory.listFiles(this.mFileFilter);
    }

    private void fitCache() {
        this.mFitLock.lock();
        try {
            if (this.mCacheFitting) {
                this.mCacheFitRequested = true;
            } else {
                this.mCacheFitting = true;
                InternalUtils.getStorageCacheExecutor().execute(this.mFitCacheSizeTask);
            }
        }
        finally {
            this.mFitLock.unlock();
        }
    }

    @NonNull
    private static File getDefaultDirectory(@NonNull Context context) {
        File directory = context.getExternalCacheDir();
        if (directory == null) {
            directory = context.getCacheDir();
        }
        return new File(directory, DEFAULT_DIRECTORY);
    }

    private static final class CacheFileFilter
    implements FileFilter {
        private CacheFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }

    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(@NonNull File lhs, @NonNull File rhs) {
            return Long.signum(rhs.lastModified() - lhs.lastModified());
        }
    }

    private final class FitCacheSizeTask
    implements Runnable {
        private FitCacheSizeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    File[] files = StorageImageCache.this.getCacheFiles();
                    if (files != null && files.length != 0) {
                        File removing;
                        Arrays.sort(files, StorageImageCache.this.mFileComparator);
                        long size = 0L;
                        for (File file : files) {
                            size += file.length();
                        }
                        for (int i = files.length - 1; size > StorageImageCache.this.mMaxSize && i >= 0; size -= removing.length(), --i) {
                            removing = files[i];
                            removing.delete();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StorageImageCache.this.mFitLock.lock();
                try {
                    if (StorageImageCache.this.mCacheFitRequested) {
                        StorageImageCache.this.mCacheFitRequested = false;
                        continue;
                    }
                    StorageImageCache.this.mCacheFitting = false;
                }
                finally {
                    StorageImageCache.this.mFitLock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

