/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.LoadUtils;

final class ObjectImageSource<T>
implements ImageSource<T> {
    private final T mData;
    private final String mKey;

    public ObjectImageSource(@NonNull T data) {
        this.mData = data;
        this.mKey = LoadUtils.generateSHA256(data.toString());
    }

    @Override
    @NonNull
    public T getData() {
        return this.mData;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ObjectImageSource && this.mKey.equals(((ObjectImageSource)obj).mKey);
    }

    @NonNull
    public String toString() {
        return "StringImageSource [key: " + this.mKey + ", data: " + this.mData + "]";
    }
}

