/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class InternalUtils {
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private static final String URI_SCHEME_FTP = "ftp";
    private static final Lock MAIN_THREAD_HANDLER_LOCK = new ReentrantLock();
    private static final Lock LOADER_EXECUTOR_LOCK = new ReentrantLock();
    private static final Lock CACHE_EXECUTOR_LOCK = new ReentrantLock();
    private static volatile Handler sMainThreadHandler;
    private static volatile ThreadPoolExecutor sImageLoaderExecutor;
    private static volatile ThreadPoolExecutor sStorageCacheExecutor;

    private InternalUtils() {
    }

    public static long getAvailableBytes(@NonNull File path) {
        StatFs statFs = new StatFs(path.getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getAvailableBytes();
        }
        return statFs.getAvailableBlocks() * statFs.getBlockSize();
    }

    public static long getTotalBytes(@NonNull File path) {
        StatFs statFs = new StatFs(path.getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getTotalBytes();
        }
        return statFs.getBlockCount() * statFs.getBlockSize();
    }

    public static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    @NonNull
    public static <T> T requireNonNull(@Nullable T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    @Nullable
    public static InputStream getDataStreamFromUri(@NonNull Context context, @NonNull Uri uri) throws IOException {
        String scheme = uri.getScheme();
        if (URI_SCHEME_HTTP.equalsIgnoreCase(scheme) || URI_SCHEME_HTTPS.equalsIgnoreCase(scheme) || URI_SCHEME_FTP.equalsIgnoreCase(scheme)) {
            return new URL(uri.toString()).openConnection().getInputStream();
        }
        return context.getContentResolver().openInputStream(uri);
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AnyThread
    public static void runOnMainThread(@NonNull Runnable action) {
        InternalUtils.getMainThreadHandler().post(action);
    }

    @NonNull
    public static ThreadPoolExecutor getImageLoaderExecutor() {
        ThreadPoolExecutor executor = sImageLoaderExecutor;
        if (executor == null) {
            LOADER_EXECUTOR_LOCK.lock();
            try {
                executor = sImageLoaderExecutor;
                if (executor == null) {
                    sImageLoaderExecutor = executor = new ImageLoaderExecutor(Math.round((float)Runtime.getRuntime().availableProcessors() * 1.5f), 1);
                }
            }
            finally {
                LOADER_EXECUTOR_LOCK.unlock();
            }
        }
        return executor;
    }

    @NonNull
    public static ThreadPoolExecutor getStorageCacheExecutor() {
        ThreadPoolExecutor executor = sStorageCacheExecutor;
        if (executor == null) {
            CACHE_EXECUTOR_LOCK.lock();
            try {
                executor = sStorageCacheExecutor;
                if (executor == null) {
                    sStorageCacheExecutor = executor = new ImageLoaderExecutor(1, 1);
                }
            }
            finally {
                CACHE_EXECUTOR_LOCK.unlock();
            }
        }
        return executor;
    }

    @NonNull
    private static Handler getMainThreadHandler() {
        Handler handler = sMainThreadHandler;
        if (handler == null) {
            MAIN_THREAD_HANDLER_LOCK.lock();
            try {
                handler = sMainThreadHandler;
                if (handler == null) {
                    sMainThreadHandler = handler = new Handler(Looper.getMainLooper());
                }
            }
            finally {
                MAIN_THREAD_HANDLER_LOCK.unlock();
            }
        }
        return handler;
    }
}

