/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.TypedValue;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.ImageSourceImpl;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.MemoryImageCacheImpl;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.StorageImageCacheImpl;
import com.budiyev.android.imageloader.UriBitmapLoader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ImageLoaderUtils {
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    private static final String DEFAULT_STORAGE_CACHE_DIRECTORY = "image_loader_cache";
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final double DEFAULT_STORAGE_FRACTION = 0.1;
    private static final float DEFAULT_MEMORY_FRACTION = 0.25f;
    private static final int DEFAULT_COMPRESS_QUALITY = 85;

    private ImageLoaderUtils() {
    }

    public static int getMaxMemoryFraction(@FloatRange(from=0.1, to=0.8) float fraction) {
        if (fraction < 0.1f || fraction > 0.8f) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.1 and 0.8 (inclusive)");
        }
        return Math.round(fraction * (float)Runtime.getRuntime().maxMemory());
    }

    public static long getAvailableStorageFraction(@NonNull File path, @FloatRange(from=0.01, to=1.0) double fraction) {
        if (fraction < 0.01 || fraction > 1.0) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.01 and 1.0 (inclusive)");
        }
        return Math.round((double)InternalUtils.getAvailableBytes(path) * fraction);
    }

    public static long getTotalStorageFraction(@NonNull File path, @FloatRange(from=0.01, to=1.0) double fraction) {
        if (fraction < 0.01 || fraction > 1.0) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.01 and 1.0 (inclusive)");
        }
        return Math.round((double)InternalUtils.getTotalBytes(path) * fraction);
    }

    public static int calculateSampleSize(int sourceWidth, int sourceHeight, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        int sampleSize = 1;
        if (sourceWidth > requiredWidth || sourceHeight > requiredHeight) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            while (halfWidth / sampleSize > requiredWidth && halfHeight / sampleSize > requiredHeight) {
                sampleSize *= 2;
            }
            if (ignoreTotalNumberOfPixels) {
                return sampleSize;
            }
            long totalRequiredPixels = requiredWidth * requiredHeight;
            for (long totalPixels = (long)(sourceWidth * sourceHeight / (sampleSize * sampleSize)); totalPixels > totalRequiredPixels; totalPixels /= 4L) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUri(@NonNull Context context, @NonNull Uri uri, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        finally {
            InternalUtils.close(inputStream);
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageLoaderUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFile(@NonNull File file, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws FileNotFoundException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageLoaderUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFileDescriptor(@NonNull FileDescriptor fileDescriptor, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = new FileInputStream(fileDescriptor);
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageLoaderUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = new FileInputStream(fileDescriptor);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromResource(@NonNull Resources resources, int resourceId, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        TypedValue typedValue = new TypedValue();
        options.inJustDecodeBounds = true;
        options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        InputStream inputStream = resources.openRawResource(resourceId, typedValue);
        if (typedValue.density == 0) {
            options.inDensity = 160;
        } else if (typedValue.density != 65535) {
            options.inDensity = typedValue.density;
        }
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageLoaderUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = resources.openRawResource(resourceId, typedValue);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        InternalUtils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromByteArray(@NonNull byte[] byteArray, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageLoaderUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    @NonNull
    public static BitmapLoader<Uri> newUriBitmapLoader() {
        return new UriBitmapLoader();
    }

    @NonNull
    public static BitmapLoader<File> newFileBitmapLoader() {
        return new FileBitmapLoader();
    }

    @NonNull
    public static BitmapLoader<FileDescriptor> newFileDescriptorBitmapLoader() {
        return new FileDescriptorBitmapLoader();
    }

    @NonNull
    public static BitmapLoader<Integer> newResourceBitmapLoader() {
        return new ResourceBitmapLoader();
    }

    @NonNull
    public static BitmapLoader<byte[]> newByteArrayBitmapLoader() {
        return new ByteArrayBitmapLoader();
    }

    @NonNull
    public static <T> ImageSource<T> newImageSource(@NonNull T data) {
        return new ImageSourceImpl<T>(data);
    }

    @NonNull
    public static String generateSHA256(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_SHA256);
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static MemoryImageCache newMemoryImageCache(int maxSize) {
        return new MemoryImageCacheImpl(maxSize);
    }

    @NonNull
    public static MemoryImageCache newMemoryImageCache() {
        return ImageLoaderUtils.newMemoryImageCache(ImageLoaderUtils.getMaxMemoryFraction(0.25f));
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull File directory, long maxSize, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return new StorageImageCacheImpl(directory, maxSize, compressFormat, compressQuality);
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return ImageLoaderUtils.newStorageImageCache(directory, ImageLoaderUtils.getTotalStorageFraction(directory, 0.1), DEFAULT_COMPRESS_FORMAT, 85);
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull Context context) {
        return ImageLoaderUtils.newStorageImageCache(ImageLoaderUtils.getDefaultStorageCacheDirectory(context));
    }

    @NonNull
    public static File getDefaultStorageCacheDirectory(@NonNull Context context) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        return new File(cacheDir, DEFAULT_STORAGE_CACHE_DIRECTORY);
    }

    @NonNull
    public static Bitmap invertColors(@NonNull Bitmap image) {
        return ImageLoaderUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}));
    }

    @NonNull
    public static Bitmap convertToGrayScale(@NonNull Bitmap image) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return ImageLoaderUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(colorMatrix));
    }

    @NonNull
    public static Bitmap applyColorFilter(@NonNull Bitmap image, @NonNull ColorFilter colorFilter) {
        Paint paint = new Paint(3);
        paint.setColorFilter(InternalUtils.requireNonNull(colorFilter));
        Bitmap bitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        new Canvas(bitmap).drawBitmap(image, 0.0f, 0.0f, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap cropCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        Bitmap cropped;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageLoaderUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageLoaderUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int cropWidth = resultRatioWidth * sourceHeight / resultRatioHeight;
        if (cropWidth > sourceWidth) {
            int cropHeight = resultRatioHeight * sourceWidth / resultRatioWidth;
            cropped = Bitmap.createBitmap((Bitmap)image, (int)0, (int)((sourceHeight - cropHeight) / 2), (int)sourceWidth, (int)cropHeight);
            if (cropHeight == resultHeight && sourceWidth == resultWidth) {
                return cropped;
            }
        } else {
            cropped = Bitmap.createBitmap((Bitmap)image, (int)((sourceWidth - cropWidth) / 2), (int)0, (int)cropWidth, (int)sourceHeight);
            if (cropWidth == resultWidth && sourceHeight == resultHeight) {
                return cropped;
            }
        }
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)cropped, (int)resultWidth, (int)resultHeight, (boolean)true);
        if (cropped != image && cropped != scaled) {
            cropped.recycle();
        }
        return scaled;
    }

    @NonNull
    public static Bitmap fitCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageLoaderUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageLoaderUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        Bitmap result = Bitmap.createBitmap((int)resultWidth, (int)resultHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        result.setDensity(image.getDensity());
        Canvas canvas = new Canvas(result);
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            int top = (resultHeight - fitHeight) / 2;
            canvas.drawBitmap(image, null, new Rect(0, top, resultWidth, top + fitHeight), new Paint(3));
        } else {
            int left = (resultWidth - fitWidth) / 2;
            canvas.drawBitmap(image, null, new Rect(left, 0, left + fitWidth, resultHeight), new Paint(3));
        }
        return result;
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        return ImageLoaderUtils.scaleToFit(image, resultWidth, resultHeight, false);
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight, boolean upscale) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        if (!upscale && sourceWidth < resultWidth && sourceHeight < resultHeight) {
            return image;
        }
        int sourceDivisor = ImageLoaderUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageLoaderUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            if (sourceWidth == resultWidth) {
                return image;
            }
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)fitHeight, (boolean)true);
        }
        if (sourceHeight == resultHeight) {
            return image;
        }
        return Bitmap.createScaledBitmap((Bitmap)image, (int)fitWidth, (int)resultHeight, (boolean)true);
    }

    @NonNull
    public static Bitmap roundCorners(@NonNull Bitmap image, float cornerRadius) {
        Paint paint = new Paint(3);
        paint.setColor(-12434878);
        int width = image.getWidth();
        int height = image.getHeight();
        Rect rect = new Rect(0, 0, width, height);
        RectF rectF = new RectF(rect);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(image, rect, rect, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap mirrorHorizontally(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap mirrorVertically(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f, -1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap rotate(@NonNull Bitmap image, float rotationAngle) {
        Matrix matrix = new Matrix();
        matrix.setRotate(rotationAngle);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static int greatestCommonDivisor(int a, int b) {
        while (a > 0 && b > 0) {
            if (a > b) {
                a %= b;
                continue;
            }
            b %= a;
        }
        return a + b;
    }
}

