/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ImageLoaderThreadFactory
implements ThreadFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final int mPriority;

    public ImageLoaderThreadFactory(@IntRange(from=1L, to=10L) int priority) {
        this.mPriority = priority;
    }

    @Override
    public Thread newThread(@NonNull Runnable runnable) {
        COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        Thread thread = new Thread(runnable, "ImageLoader thread #" + COUNTER.getAndIncrement());
        if (thread.getPriority() != this.mPriority) {
            thread.setPriority(this.mPriority);
        }
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        return thread;
    }
}

