/*
 * MIT License
 *
 * Copyright (c) 2017 Yuriy Budiyev [yuriy.budiyev@yandex.ru]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;

/**
 * {@link Bitmap} loader for {@link ImageLoader}
 *
 * @see ImageLoader#getBitmapLoader()
 * @see ImageLoader#setBitmapLoader(BitmapLoader)
 * @see ImageLoaderUtils#newUriBitmapLoader()
 * @see ImageLoaderUtils#newFileBitmapLoader()
 * @see ImageLoaderUtils#newFileDescriptorBitmapLoader()
 * @see ImageLoaderUtils#newResourceBitmapLoader()
 * @see ImageLoaderUtils#newByteArrayBitmapLoader()
 */
public interface BitmapLoader<T> {
    /**
     * Load {@link Bitmap} from source data
     *
     * @param t Source data
     * @return Loaded bitmap; or {@code null} if unable to load it, in that case,
     * {@link ErrorCallback#onError(ImageSource, Throwable)} will be called with
     * {@link NullPointerException}.
     * @throws Throwable if unable to load {@link Bitmap}, this exception will be transferred
     *                   to {@link ErrorCallback#onError(ImageSource, Throwable)} method.
     */
    @Nullable
    @WorkerThread
    Bitmap load(@NonNull Context context, @NonNull T t) throws Throwable;
}
