/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.view.View;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.Callbacks;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.RecyclingBitmapDrawable;
import com.budiyev.android.imageloader.SetImageAction;
import com.budiyev.android.imageloader.StorageImageCache;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class LoadImageAction<T> {
    private final ImageSource<T> mImageSource;
    private final WeakReference<View> mViewReference;
    private final ImageLoader<T> mImageLoader;
    private final Lock mPauseLoadingLock;
    private final Condition mPauseLoadingCondition;
    private final Callbacks<T> mCallbacks;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;

    public LoadImageAction(@NonNull ImageSource<T> source, @NonNull View view, @Nullable Callbacks<T> callback, @NonNull ImageLoader<T> loader, @NonNull Lock lock, @NonNull Condition condition) {
        this.mImageSource = source;
        this.mViewReference = new WeakReference<View>(view);
        this.mImageLoader = loader;
        this.mPauseLoadingLock = lock;
        this.mPauseLoadingCondition = condition;
        this.mCallbacks = callback;
    }

    public void execute() {
        if (this.mCancelled) {
            return;
        }
        this.mFuture = InternalUtils.getImageLoaderExecutor().submit(new LoadImageTask());
    }

    public void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
    }

    @NonNull
    public ImageSource<T> getImageSource() {
        return this.mImageSource;
    }

    @Nullable
    @MainThread
    public View getAttachedView() {
        View imageView = (View)this.mViewReference.get();
        LoadImageAction<?> loadImageAction = this.mImageLoader.getLoadImageAction(imageView);
        if (loadImageAction == this) {
            return imageView;
        }
        return null;
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    @WorkerThread
    private void loadImage() {
        while (!this.mCancelled && this.mImageLoader.isLoadingPaused() && !this.mImageLoader.isExitTasksEarly()) {
            this.mPauseLoadingLock.lock();
            try {
                this.mPauseLoadingCondition.await();
            }
            catch (InterruptedException e) {
                return;
            }
            finally {
                this.mPauseLoadingLock.unlock();
            }
        }
        if (this.mCancelled || this.mImageLoader.isExitTasksEarly()) {
            return;
        }
        Bitmap image = null;
        StorageImageCache storageImageCache = this.mImageLoader.getStorageImageCache();
        String key = this.mImageSource.getKey();
        T data = this.mImageSource.getData();
        if (storageImageCache != null) {
            image = storageImageCache.get(key);
        }
        Context context = this.mImageLoader.getContext();
        if (image == null) {
            BitmapLoader<T> bitmapLoader = this.mImageLoader.getBitmapLoader();
            if (bitmapLoader != null) {
                try {
                    image = bitmapLoader.load(context, data);
                }
                catch (Throwable error) {
                    Callbacks.notifyError(this.mCallbacks, this.mImageSource, error);
                    return;
                }
                if (image == null) {
                    Callbacks.notifyError(this.mCallbacks, this.mImageSource, new NullPointerException("BitmapLoader returned null"));
                    return;
                }
            }
            if (image != null) {
                Callbacks.notifyLoaded(this.mCallbacks, this.mImageSource, image);
                if (storageImageCache != null) {
                    storageImageCache.put(key, image);
                }
            }
        }
        if (image == null) {
            return;
        }
        RecyclingBitmapDrawable drawable = new RecyclingBitmapDrawable(context.getResources(), image);
        MemoryImageCache memoryImageCache = this.mImageLoader.getMemoryImageCache();
        if (memoryImageCache != null) {
            memoryImageCache.put(key, drawable);
        }
        if (this.mCancelled || this.mImageLoader.isExitTasksEarly()) {
            return;
        }
        InternalUtils.runOnMainThread(new SetImageAction<T>(drawable, this.mImageLoader, this.mCallbacks, this));
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            LoadImageAction.this.loadImage();
            LoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

