/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.Callbacks;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.PlaceholderProvider;
import com.budiyev.android.imageloader.PlaceholderProviderImpl;
import com.budiyev.android.imageloader.StorageImageCache;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader<T> {
    private final Lock mPauseLoadingLock = new ReentrantLock();
    private final Condition mPauseLoadingCondition = this.mPauseLoadingLock.newCondition();
    private final Context mContext;
    private volatile BitmapLoader<T> mBitmapLoader;
    private volatile MemoryImageCache mMemoryImageCache;
    private volatile StorageImageCache mStorageImageCache;
    private volatile PlaceholderProvider<T> mPlaceholderProvider;
    private volatile boolean mImageFadeIn = true;
    private volatile boolean mExitTasksEarly;
    private volatile boolean mLoadingPaused;
    private volatile int mImageFadeInTime = 250;

    public ImageLoader(@NonNull Context context) {
        this.mContext = InternalUtils.requireNonNull(context);
    }

    public ImageLoader(@NonNull Context context, @Nullable BitmapLoader<T> bitmapLoader, @Nullable MemoryImageCache memoryImageCache, @Nullable StorageImageCache storageImageCache) {
        this.mContext = InternalUtils.requireNonNull(context);
        this.mBitmapLoader = bitmapLoader;
        this.mMemoryImageCache = memoryImageCache;
        this.mStorageImageCache = storageImageCache;
    }

    @NonNull
    protected Context getContext() {
        return this.mContext;
    }

    @MainThread
    public void loadImage(@NonNull ImageSource<T> source, @NonNull View view, @Nullable Callbacks<T> callbacks) {
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        BitmapDrawable drawable = null;
        if (memoryImageCache != null) {
            drawable = memoryImageCache.get(source.getKey());
        }
        if (drawable != null) {
            this.setDrawable(view, (Drawable)drawable);
            Callbacks.notifyDisplayed(callbacks, source, drawable, view);
        } else if (this.cancelPotentialWork(source, view)) {
            LoadImageAction<T> loadAction = new LoadImageAction<T>(source, view, callbacks, this, this.mPauseLoadingLock, this.mPauseLoadingCondition);
            PlaceholderDrawable placeholderDrawable = new PlaceholderDrawable(this.getPlaceholderDrawable(source), loadAction);
            this.setDrawable(view, (Drawable)placeholderDrawable);
            loadAction.execute();
        }
    }

    @MainThread
    public void loadImage(@NonNull ImageSource<T> source, @NonNull View view) {
        this.loadImage(source, view, null);
    }

    public void invalidate(@NonNull ImageSource<T> source) {
        StorageImageCache storageImageCache;
        String key = source.getKey();
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        if (memoryImageCache != null) {
            memoryImageCache.remove(key);
        }
        if ((storageImageCache = this.getStorageImageCache()) != null) {
            storageImageCache.remove(key);
        }
    }

    @NonNull
    public Callbacks<T> makeCallbacks() {
        return new Callbacks();
    }

    public void setPlaceholderProvider(@Nullable PlaceholderProvider<T> provider) {
        this.mPlaceholderProvider = provider;
    }

    @Nullable
    public PlaceholderProvider<T> getPlaceholderProvider() {
        return this.mPlaceholderProvider;
    }

    @NonNull
    public Drawable getPlaceholderDrawable(@NonNull ImageSource<T> source) {
        PlaceholderProvider<T> provider = this.getPlaceholderProvider();
        if (provider == null) {
            return new ColorDrawable(0);
        }
        return provider.get(this.getContext(), source.getData());
    }

    public void setPlaceholderImage(@NonNull Bitmap image) {
        this.mPlaceholderProvider = new PlaceholderProviderImpl(this.getContext().getResources(), image);
    }

    public void setPlaceholderImage(int resourceId) {
        Resources resources = this.getContext().getResources();
        this.mPlaceholderProvider = new PlaceholderProviderImpl(resources, BitmapFactory.decodeResource((Resources)resources, (int)resourceId));
    }

    @Nullable
    public BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    public void setBitmapLoader(@Nullable BitmapLoader<T> loader) {
        this.mBitmapLoader = loader;
    }

    @Nullable
    public MemoryImageCache getMemoryImageCache() {
        return this.mMemoryImageCache;
    }

    public void setMemoryImageCache(@Nullable MemoryImageCache cache) {
        this.mMemoryImageCache = cache;
    }

    @Nullable
    public StorageImageCache getStorageImageCache() {
        return this.mStorageImageCache;
    }

    public void setStorageImageCache(@Nullable StorageImageCache cache) {
        this.mStorageImageCache = cache;
    }

    public boolean isImageFadeIn() {
        return this.mImageFadeIn;
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.mImageFadeIn = fadeIn;
    }

    public boolean isLoadingPaused() {
        return this.mLoadingPaused;
    }

    public void setPauseLoading(boolean pause) {
        this.mPauseLoadingLock.lock();
        try {
            this.mLoadingPaused = pause;
            if (!pause) {
                this.mPauseLoadingCondition.signalAll();
            }
        }
        finally {
            this.mPauseLoadingLock.unlock();
        }
    }

    public boolean isExitTasksEarly() {
        return this.mExitTasksEarly;
    }

    public void setExitTasksEarly(boolean exit) {
        this.mExitTasksEarly = exit;
        if (exit) {
            this.mPauseLoadingLock.lock();
            try {
                this.mPauseLoadingCondition.signalAll();
            }
            finally {
                this.mPauseLoadingLock.unlock();
            }
        }
    }

    public int getImageFadeInTime() {
        return this.mImageFadeInTime;
    }

    public void setImageFadeInTime(int time) {
        this.mImageFadeInTime = time;
    }

    public void clearCache() {
        StorageImageCache storageImageCache;
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        if (memoryImageCache != null) {
            memoryImageCache.clear();
        }
        if ((storageImageCache = this.getStorageImageCache()) != null) {
            storageImageCache.clear();
        }
    }

    public void setDrawable(@NonNull View view, @Nullable Drawable drawable) {
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    @Nullable
    public Drawable getDrawable(@NonNull View view) {
        if (view instanceof ImageView) {
            return ((ImageView)view).getDrawable();
        }
        return view.getBackground();
    }

    @MainThread
    public void cancelWork(@Nullable View view) {
        LoadImageAction<?> loadImageAction = this.getLoadImageAction(view);
        if (loadImageAction != null) {
            loadImageAction.cancel();
        }
    }

    @MainThread
    public boolean cancelPotentialWork(@NonNull ImageSource<?> source, @Nullable View view) {
        LoadImageAction<?> loadImageAction = this.getLoadImageAction(view);
        if (loadImageAction != null) {
            if (!InternalUtils.equals(loadImageAction.getImageSource().getKey(), source.getKey())) {
                loadImageAction.cancel();
            } else {
                return false;
            }
        }
        return true;
    }

    @Nullable
    @MainThread
    LoadImageAction<?> getLoadImageAction(@Nullable View view) {
        Drawable drawable;
        if (view != null && (drawable = this.getDrawable(view)) instanceof PlaceholderDrawable) {
            return ((PlaceholderDrawable)drawable).getLoadImageAction();
        }
        return null;
    }
}

