/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.view.View;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.LoadCallback;

public final class Callbacks<T> {
    private volatile LoadCallback<T> mLoadCallback;
    private volatile ErrorCallback<T> mErrorCallback;
    private volatile DisplayCallback<T> mDisplayCallback;

    @NonNull
    public Callbacks<T> load(@Nullable LoadCallback<T> callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public Callbacks<T> error(@Nullable ErrorCallback<T> callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public Callbacks<T> display(@Nullable DisplayCallback<T> callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @WorkerThread
    static <T> void notifyLoaded(@Nullable Callbacks<T> callbacks, @NonNull ImageSource<T> source, @NonNull Bitmap image) {
        if (callbacks == null) {
            return;
        }
        LoadCallback<T> callback = callbacks.mLoadCallback;
        if (callback == null) {
            return;
        }
        callback.onLoaded(source, image);
    }

    @WorkerThread
    static <T> void notifyError(@Nullable Callbacks<T> callbacks, @NonNull ImageSource<T> source, @NonNull Throwable error) {
        if (callbacks == null) {
            return;
        }
        ErrorCallback<T> callback = callbacks.mErrorCallback;
        if (callback == null) {
            return;
        }
        callback.onError(source, error);
    }

    @MainThread
    static <T> void notifyDisplayed(@Nullable Callbacks<T> callbacks, @NonNull ImageSource<T> source, @NonNull BitmapDrawable drawable, @NonNull View view) {
        if (callbacks == null) {
            return;
        }
        DisplayCallback<T> callback = callbacks.mDisplayCallback;
        if (callback == null) {
            return;
        }
        callback.onDisplayed(source, drawable, view);
    }
}

