/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;

final class StorageImageCacheImpl
implements StorageImageCache {
    private final AtomicBoolean mCacheSizeFitting = new AtomicBoolean();
    private final AtomicBoolean mCacheSizeFitRequested = new AtomicBoolean();
    private final File mDirectory;
    private final long mMaxSize;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final Runnable mFitCacheSizeAction = new Runnable(){

        @Override
        public void run() {
            do {
                try {
                    File removing;
                    File[] files = StorageImageCacheImpl.this.getCacheFiles();
                    if (files == null || files.length < 2) {
                        return;
                    }
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return Long.signum(rhs.lastModified() - lhs.lastModified());
                        }
                    });
                    long size = 0L;
                    for (File file : files) {
                        size += file.length();
                    }
                    for (int i = files.length - 1; size > StorageImageCacheImpl.this.mMaxSize && i >= 0; size -= removing.length(), --i) {
                        removing = files[i];
                        removing.delete();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (StorageImageCacheImpl.this.mCacheSizeFitRequested.compareAndSet(true, false));
            StorageImageCacheImpl.this.mCacheSizeFitting.set(false);
        }
    };

    public StorageImageCacheImpl(@NonNull File directory, long maxSize, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        this.mDirectory = directory;
        this.mMaxSize = maxSize;
        this.mCompressFormat = compressFormat;
        this.mCompressQuality = compressQuality;
        this.fitCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        if (!this.mDirectory.exists()) {
            this.mDirectory.mkdirs();
        }
        File file = new File(this.mDirectory, key);
        this.deleteCacheFile(file);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            value.compress(this.mCompressFormat, this.mCompressQuality, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                this.deleteCacheFile(file);
            }
            catch (Throwable throwable) {
                Utils.close(outputStream);
                throw throwable;
            }
            Utils.close(outputStream);
        }
        Utils.close(outputStream);
        this.fitCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        Bitmap bitmap;
        File file = new File(this.mDirectory, key);
        if (!file.exists() && !file.isFile()) {
            return null;
        }
        file.setLastModified(System.currentTimeMillis());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (IOException e) {
            Bitmap bitmap2;
            try {
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
            Utils.close(inputStream);
            return bitmap2;
        }
        Utils.close(inputStream);
        return bitmap;
    }

    @Override
    public void remove(@NonNull String key) {
        this.deleteCacheFile(new File(this.mDirectory, key));
    }

    @Override
    public void clear() {
        File[] files = this.getCacheFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    @Nullable
    private File[] getCacheFiles() {
        return this.mDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    private void deleteCacheFile(@NonNull File file) {
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    private void fitCacheSize() {
        if (this.mCacheSizeFitting.compareAndSet(false, true)) {
            Utils.getStorageCacheExecutor().execute(this.mFitCacheSizeAction);
        } else {
            this.mCacheSizeFitRequested.set(true);
        }
    }
}

