/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ImageLoaderImpl
extends ImageLoader<Uri> {
    private static final Lock INSTANCE_LOCK = new ReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ImageLoaderImpl sInstance;

    private ImageLoaderImpl(@NonNull Context context) {
        super(context.getApplicationContext());
        this.setBitmapLoader(ImageLoaderImpl.newUriBitmapLoader());
        this.setMemoryImageCache(ImageLoaderImpl.newMemoryImageCache());
        this.setStorageImageCache(ImageLoaderImpl.newStorageImageCache(context));
    }

    @NonNull
    public static ImageLoaderImpl getInstance(@NonNull Context context) {
        ImageLoaderImpl instance = sInstance;
        if (instance == null) {
            INSTANCE_LOCK.lock();
            try {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new ImageLoaderImpl(context);
                }
            }
            finally {
                INSTANCE_LOCK.unlock();
            }
        }
        return instance;
    }
}

