/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.ImageLoadCallback;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.RecyclingBitmapDrawable;
import com.budiyev.android.imageloader.SetImageAction;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.Utils;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class LoadImageAction<T> {
    private final ImageSource<T> mImageSource;
    private final WeakReference<ImageView> mImageViewReference;
    private final ImageLoader<T> mImageLoader;
    private final Lock mPauseLoadingLock;
    private final Condition mPauseLoadingCondition;
    private final ImageLoadCallback<T> mImageLoadCallback;
    private final AtomicBoolean mExecuting = new AtomicBoolean();
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;

    public LoadImageAction(@NonNull ImageSource<T> source, @NonNull ImageView view, @Nullable ImageLoadCallback<T> callback, @NonNull ImageLoader<T> loader, @NonNull Lock lock, @NonNull Condition condition) {
        this.mImageSource = source;
        this.mImageViewReference = new WeakReference<ImageView>(view);
        this.mImageLoader = loader;
        this.mPauseLoadingLock = lock;
        this.mPauseLoadingCondition = condition;
        this.mImageLoadCallback = callback;
    }

    public boolean execute() {
        if (!this.mCancelled && this.mExecuting.compareAndSet(false, true)) {
            this.mFuture = Utils.getImageLoaderExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    LoadImageAction.this.loadImage();
                    LoadImageAction.this.mFuture = null;
                    LoadImageAction.this.mExecuting.set(false);
                }
            });
            return true;
        }
        return false;
    }

    public void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
    }

    @NonNull
    public ImageSource<T> getImageSource() {
        return this.mImageSource;
    }

    @Nullable
    @MainThread
    public ImageView getAttachedImageView() {
        ImageView imageView = (ImageView)this.mImageViewReference.get();
        LoadImageAction<?> loadImageAction = ImageLoader.getLoadImageAction(imageView);
        if (loadImageAction == this) {
            return imageView;
        }
        return null;
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    @WorkerThread
    private void loadImage() {
        this.mPauseLoadingLock.lock();
        try {
            while (!this.mCancelled && this.mImageLoader.isLoadingPaused() && !this.mImageLoader.isExitTasksEarly()) {
                this.mPauseLoadingCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mPauseLoadingLock.unlock();
        }
        if (this.mCancelled || this.mImageLoader.isExitTasksEarly()) {
            return;
        }
        Bitmap image = null;
        StorageImageCache storageImageCache = this.mImageLoader.getStorageImageCache();
        String key = this.mImageSource.getKey();
        T data = this.mImageSource.getData();
        if (storageImageCache != null && (image = storageImageCache.get(key)) != null && this.mImageLoadCallback != null) {
            this.reportImageLoaded(data, image, false, true);
        }
        if (image == null) {
            BitmapLoader<T> bitmapLoader = this.mImageLoader.getBitmapLoader();
            if (bitmapLoader != null) {
                try {
                    image = bitmapLoader.load(this.mImageLoader.getContext(), data);
                }
                catch (Exception exception) {
                    this.reportError(data, exception);
                    return;
                }
                if (image == null) {
                    this.reportError(data, new NullPointerException("BitmapLoader returned null."));
                    return;
                }
            }
            if (image != null) {
                this.reportImageLoaded(data, image, false, false);
                if (storageImageCache != null) {
                    storageImageCache.put(key, image);
                }
            }
        }
        RecyclingBitmapDrawable drawable = null;
        if (image != null) {
            drawable = new RecyclingBitmapDrawable(this.mImageLoader.getContext().getResources(), image);
            MemoryImageCache memoryImageCache = this.mImageLoader.getMemoryImageCache();
            if (memoryImageCache != null) {
                memoryImageCache.put(key, drawable);
            }
        }
        if (this.mCancelled || this.mImageLoader.isExitTasksEarly()) {
            return;
        }
        Utils.runOnMainThread(new SetImageAction<T>(drawable, this.mImageLoader, this.mImageLoadCallback, this));
    }

    private void reportImageLoaded(final @NonNull T data, final @NonNull Bitmap image, final boolean fromMemoryCache, final boolean fromStorageCache) {
        if (this.mImageLoadCallback != null) {
            Utils.runOnMainThread(new Runnable(){

                @Override
                @MainThread
                public void run() {
                    LoadImageAction.this.mImageLoadCallback.onLoaded(data, image, fromMemoryCache, fromStorageCache);
                }
            });
        }
    }

    private void reportError(final @NonNull T data, final @NonNull Exception exception) {
        if (this.mImageLoadCallback != null) {
            Utils.runOnMainThread(new Runnable(){

                @Override
                @MainThread
                public void run() {
                    LoadImageAction.this.mImageLoadCallback.onError(data, exception);
                }
            });
        }
    }
}

