/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.Utils;

public final class ImageUtils {
    private ImageUtils() {
    }

    @NonNull
    public static Bitmap invertColors(@NonNull Bitmap image) {
        return ImageUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}));
    }

    @NonNull
    public static Bitmap convertToGrayScale(@NonNull Bitmap image) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return ImageUtils.applyColorFilter(image, (ColorFilter)new ColorMatrixColorFilter(colorMatrix));
    }

    @NonNull
    public static Bitmap applyColorFilter(@NonNull Bitmap image, @NonNull ColorFilter colorFilter) {
        Paint paint = new Paint(3);
        paint.setColorFilter(Utils.requireNonNull(colorFilter));
        Bitmap bitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        new Canvas(bitmap).drawBitmap(image, 0.0f, 0.0f, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap cropCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        Bitmap cropped;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int cropWidth = resultRatioWidth * sourceHeight / resultRatioHeight;
        if (cropWidth > sourceWidth) {
            int cropHeight = resultRatioHeight * sourceWidth / resultRatioWidth;
            cropped = Bitmap.createBitmap((Bitmap)image, (int)0, (int)((sourceHeight - cropHeight) / 2), (int)sourceWidth, (int)cropHeight);
            if (cropHeight == resultHeight && sourceWidth == resultWidth) {
                return cropped;
            }
        } else {
            cropped = Bitmap.createBitmap((Bitmap)image, (int)((sourceWidth - cropWidth) / 2), (int)0, (int)cropWidth, (int)sourceHeight);
            if (cropWidth == resultWidth && sourceHeight == resultHeight) {
                return cropped;
            }
        }
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)cropped, (int)resultWidth, (int)resultHeight, (boolean)true);
        if (cropped != image && cropped != scaled) {
            cropped.recycle();
        }
        return scaled;
    }

    @NonNull
    public static Bitmap fitCenter(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        Bitmap result = Bitmap.createBitmap((int)resultWidth, (int)resultHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        result.setDensity(image.getDensity());
        Canvas canvas = new Canvas(result);
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            int top = (resultHeight - fitHeight) / 2;
            canvas.drawBitmap(image, null, new Rect(0, top, resultWidth, top + fitHeight), new Paint(3));
        } else {
            int left = (resultWidth - fitWidth) / 2;
            canvas.drawBitmap(image, null, new Rect(left, 0, left + fitWidth, resultHeight), new Paint(3));
        }
        return result;
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight) {
        return ImageUtils.scaleToFit(image, resultWidth, resultHeight, false);
    }

    @NonNull
    public static Bitmap scaleToFit(@NonNull Bitmap image, int resultWidth, int resultHeight, boolean upscale) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == resultWidth && sourceHeight == resultHeight) {
            return image;
        }
        if (!upscale && sourceWidth < resultWidth && sourceHeight < resultHeight) {
            return image;
        }
        int sourceDivisor = ImageUtils.greatestCommonDivisor(sourceWidth, sourceHeight);
        int sourceRatioWidth = sourceWidth / sourceDivisor;
        int sourceRatioHeight = sourceHeight / sourceDivisor;
        int resultDivisor = ImageUtils.greatestCommonDivisor(resultWidth, resultHeight);
        int resultRatioWidth = resultWidth / resultDivisor;
        int resultRatioHeight = resultHeight / resultDivisor;
        if (sourceRatioWidth == resultRatioWidth && sourceRatioHeight == resultRatioHeight) {
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)resultHeight, (boolean)true);
        }
        int fitWidth = sourceRatioWidth * resultHeight / sourceRatioHeight;
        if (fitWidth > resultWidth) {
            if (sourceWidth == resultWidth) {
                return image;
            }
            int fitHeight = sourceRatioHeight * resultWidth / sourceRatioWidth;
            return Bitmap.createScaledBitmap((Bitmap)image, (int)resultWidth, (int)fitHeight, (boolean)true);
        }
        if (sourceHeight == resultHeight) {
            return image;
        }
        return Bitmap.createScaledBitmap((Bitmap)image, (int)fitWidth, (int)resultHeight, (boolean)true);
    }

    @NonNull
    public static Bitmap roundCorners(@NonNull Bitmap image, float cornerRadius) {
        Paint paint = new Paint(3);
        paint.setColor(-12434878);
        int width = image.getWidth();
        int height = image.getHeight();
        Rect rect = new Rect(0, 0, width, height);
        RectF rectF = new RectF(rect);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setDensity(image.getDensity());
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(image, rect, rect, paint);
        return bitmap;
    }

    @NonNull
    public static Bitmap mirrorHorizontally(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap mirrorVertically(@NonNull Bitmap image) {
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f, -1.0f);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    @NonNull
    public static Bitmap rotate(@NonNull Bitmap image, float rotationAngle) {
        Matrix matrix = new Matrix();
        matrix.setRotate(rotationAngle);
        return Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static int greatestCommonDivisor(int a, int b) {
        while (a > 0 && b > 0) {
            if (a > b) {
                a %= b;
                continue;
            }
            b %= a;
        }
        return a + b;
    }
}

