/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.support.annotation.AnyRes;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.ImageLoadCallback;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageLoaderImpl;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.ImageSourceImpl;
import java.io.File;

public final class ImageLoadRequest {
    private final ImageLoader<Uri> mLoader;
    private volatile ImageSource<Uri> mSource;
    private volatile ImageView mView;
    private volatile ImageLoadCallback<Uri> mCallback;

    ImageLoadRequest(@NonNull Context context) {
        this.mLoader = ImageLoaderImpl.getInstance(context);
    }

    @NonNull
    public ImageLoadRequest from(@NonNull Uri source) {
        this.mSource = new ImageSourceImpl<Uri>(source);
        return this;
    }

    @NonNull
    public ImageLoadRequest from(@NonNull File source) {
        this.mSource = new ImageSourceImpl<Uri>(Uri.fromFile((File)source));
        return this;
    }

    @NonNull
    public ImageLoadRequest from(@AnyRes int resourceId) {
        Resources resources = this.mLoader.getContext().getResources();
        this.mSource = new ImageSourceImpl<Uri>(Uri.parse((String)("android.resource://" + resources.getResourcePackageName(resourceId) + "/" + resources.getResourceTypeName(resourceId) + "/" + resources.getResourceEntryName(resourceId))));
        return this;
    }

    @NonNull
    public ImageLoadRequest into(@NonNull ImageView view) {
        this.mView = view;
        return this;
    }

    @NonNull
    public ImageLoadRequest callback(@Nullable ImageLoadCallback<Uri> callback) {
        this.mCallback = callback;
        return this;
    }

    @MainThread
    public void load() {
        this.mLoader.loadImage(this.mSource, this.mView, this.mCallback);
    }
}

