/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.FadeCallback;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageLoadCallback;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.LoadImageAction;

final class SetImageAction<T>
implements Runnable {
    private final BitmapDrawable mBitmapDrawable;
    private final ImageLoader<T> mImageLoader;
    private final LoadImageAction<T> mLoadImageAction;
    private final ImageLoadCallback<T> mImageLoadCallback;

    public SetImageAction(@Nullable BitmapDrawable bitmapDrawable, @NonNull ImageLoader<T> imageLoader, @Nullable ImageLoadCallback<T> imageLoadCallback, @NonNull LoadImageAction<T> loadImageAction) {
        this.mBitmapDrawable = bitmapDrawable;
        this.mImageLoader = imageLoader;
        this.mImageLoadCallback = imageLoadCallback;
        this.mLoadImageAction = loadImageAction;
    }

    @Override
    @MainThread
    public void run() {
        if (!this.mLoadImageAction.isCancelled() && !this.mImageLoader.isExitTasksEarly()) {
            Bitmap image;
            final ImageView imageView = this.mLoadImageAction.getAttachedImageView();
            if (this.mBitmapDrawable == null || imageView == null || (image = this.mBitmapDrawable.getBitmap()) == null) {
                return;
            }
            if (this.mImageLoader.isImageFadeIn() && Build.VERSION.SDK_INT >= 19) {
                FadeDrawable fadeDrawable = new FadeDrawable((Drawable)new BitmapDrawable(this.mImageLoader.getContext().getResources(), this.mImageLoader.getPlaceholderImage(this.mLoadImageAction.getImageSource())), (Drawable)this.mBitmapDrawable);
                imageView.setImageDrawable((Drawable)fadeDrawable);
                fadeDrawable.setFadeCallback(new FadeCallback(){

                    @Override
                    @MainThread
                    public void onStart(@NonNull FadeDrawable drawable) {
                    }

                    @Override
                    @MainThread
                    public void onEnd(@NonNull FadeDrawable drawable) {
                        SetImageAction.this.reportDisplayed(image, imageView);
                    }
                });
                fadeDrawable.startFade(this.mImageLoader.getImageFadeInTime());
            } else {
                imageView.setImageDrawable((Drawable)this.mBitmapDrawable);
                this.reportDisplayed(image, imageView);
            }
        }
    }

    @MainThread
    private void reportDisplayed(@NonNull Bitmap image, @NonNull ImageView imageView) {
        if (this.mImageLoadCallback != null) {
            this.mImageLoadCallback.onDisplayed(this.mLoadImageAction.getImageSource().getData(), image, imageView);
        }
    }
}

