/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.TypedValue;
import android.widget.ImageView;
import com.budiyev.android.imageloader.AsyncBitmapDrawable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.ImageLoadCallback;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.ImageSourceImpl;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.MemoryImageCacheImpl;
import com.budiyev.android.imageloader.PlaceholderProvider;
import com.budiyev.android.imageloader.PlaceholderProviderImpl;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.StorageImageCacheImpl;
import com.budiyev.android.imageloader.Utils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader<T> {
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    private static final String DEFAULT_STORAGE_CACHE_DIRECTORY = "image_loader_cache";
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final double DEFAULT_STORAGE_FRACTION = 0.1;
    private static final float DEFAULT_MEMORY_FRACTION = 0.25f;
    private static final int DEFAULT_COMPRESS_QUALITY = 85;
    private final Lock mPauseLoadingLock = new ReentrantLock();
    private final Condition mPauseLoadingCondition = this.mPauseLoadingLock.newCondition();
    private final Context mContext;
    private volatile BitmapLoader<T> mBitmapLoader;
    private volatile MemoryImageCache mMemoryImageCache;
    private volatile StorageImageCache mStorageImageCache;
    private volatile PlaceholderProvider<T> mPlaceholderProvider;
    private volatile boolean mImageFadeIn = true;
    private volatile boolean mExitTasksEarly;
    private volatile boolean mLoadingPaused;
    private volatile int mImageFadeInTime = 200;

    public ImageLoader(@NonNull Context context) {
        this(context, null, null, null);
    }

    public ImageLoader(@NonNull Context context, @Nullable BitmapLoader<T> bitmapLoader) {
        this(context, bitmapLoader, ImageLoader.newMemoryImageCache(), ImageLoader.newStorageImageCache(context));
    }

    public ImageLoader(@NonNull Context context, @Nullable BitmapLoader<T> bitmapLoader, @Nullable MemoryImageCache memoryImageCache, @Nullable StorageImageCache storageImageCache) {
        this.mContext = Utils.requireNonNull(context);
        this.mBitmapLoader = bitmapLoader;
        this.mMemoryImageCache = memoryImageCache;
        this.mStorageImageCache = storageImageCache;
    }

    @NonNull
    protected Context getContext() {
        return this.mContext;
    }

    @MainThread
    public void loadImage(@NonNull ImageSource<T> source, @NonNull ImageView view, @Nullable ImageLoadCallback<T> callback) {
        Bitmap image;
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        BitmapDrawable drawable = null;
        if (memoryImageCache != null) {
            drawable = memoryImageCache.get(source.getKey());
        }
        if (drawable != null && (image = drawable.getBitmap()) != null) {
            T data = source.getData();
            if (callback != null) {
                callback.onLoaded(data, image, true, false);
            }
            view.setImageDrawable((Drawable)drawable);
            if (callback != null) {
                callback.onDisplayed(data, image, view);
            }
        } else if (ImageLoader.cancelPotentialWork(source, view)) {
            LoadImageAction<T> loadAction = new LoadImageAction<T>(source, view, callback, this, this.mPauseLoadingLock, this.mPauseLoadingCondition);
            AsyncBitmapDrawable asyncBitmapDrawable = new AsyncBitmapDrawable(this.getContext().getResources(), this.getPlaceholderImage(source), loadAction);
            view.setImageDrawable((Drawable)asyncBitmapDrawable);
            loadAction.execute();
        }
    }

    @MainThread
    public void loadImage(@NonNull ImageSource<T> source, @NonNull ImageView view) {
        this.loadImage(source, view, null);
    }

    public void invalidate(@NonNull ImageSource<T> source) {
        StorageImageCache storageImageCache;
        String key = source.getKey();
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        if (memoryImageCache != null) {
            memoryImageCache.remove(key);
        }
        if ((storageImageCache = this.getStorageImageCache()) != null) {
            storageImageCache.remove(key);
        }
    }

    public void setPlaceholderProvider(@Nullable PlaceholderProvider<T> provider) {
        this.mPlaceholderProvider = provider;
    }

    @Nullable
    public PlaceholderProvider<T> getPlaceholderProvider() {
        return this.mPlaceholderProvider;
    }

    @Nullable
    public Bitmap getPlaceholderImage(@NonNull ImageSource<T> source) {
        PlaceholderProvider<T> provider = this.getPlaceholderProvider();
        if (provider == null) {
            return null;
        }
        return provider.get(this.getContext(), source.getData());
    }

    public void setPlaceholderImage(@Nullable Bitmap image) {
        this.mPlaceholderProvider = new PlaceholderProviderImpl(image);
    }

    @WorkerThread
    public void setPlaceholderImage(int resourceId) {
        this.mPlaceholderProvider = new PlaceholderProviderImpl(BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)resourceId));
    }

    @Nullable
    public BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    public void setBitmapLoader(@Nullable BitmapLoader<T> loader) {
        this.mBitmapLoader = loader;
    }

    @Nullable
    public MemoryImageCache getMemoryImageCache() {
        return this.mMemoryImageCache;
    }

    public void setMemoryImageCache(@Nullable MemoryImageCache cache) {
        this.mMemoryImageCache = cache;
    }

    @Nullable
    public StorageImageCache getStorageImageCache() {
        return this.mStorageImageCache;
    }

    public void setStorageImageCache(@Nullable StorageImageCache cache) {
        this.mStorageImageCache = cache;
    }

    public boolean isImageFadeIn() {
        return this.mImageFadeIn;
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.mImageFadeIn = fadeIn;
    }

    public boolean isLoadingPaused() {
        return this.mLoadingPaused;
    }

    public void setPauseLoading(boolean pause) {
        this.mPauseLoadingLock.lock();
        try {
            this.mLoadingPaused = pause;
            if (!pause) {
                this.mPauseLoadingCondition.signalAll();
            }
        }
        finally {
            this.mPauseLoadingLock.unlock();
        }
    }

    public boolean isExitTasksEarly() {
        return this.mExitTasksEarly;
    }

    public void setExitTasksEarly(boolean exit) {
        this.mExitTasksEarly = exit;
        if (exit) {
            this.mPauseLoadingLock.lock();
            try {
                this.mPauseLoadingCondition.signalAll();
            }
            finally {
                this.mPauseLoadingLock.unlock();
            }
        }
    }

    public int getImageFadeInTime() {
        return this.mImageFadeInTime;
    }

    public void setImageFadeInTime(int time) {
        this.mImageFadeInTime = time;
    }

    public void clearCache() {
        StorageImageCache storageImageCache;
        MemoryImageCache memoryImageCache = this.getMemoryImageCache();
        if (memoryImageCache != null) {
            memoryImageCache.clear();
        }
        if ((storageImageCache = this.getStorageImageCache()) != null) {
            storageImageCache.clear();
        }
    }

    @Nullable
    @MainThread
    public static LoadImageAction<?> getLoadImageAction(@Nullable ImageView view) {
        Drawable drawable;
        if (view != null && (drawable = view.getDrawable()) instanceof AsyncBitmapDrawable) {
            return ((AsyncBitmapDrawable)drawable).getLoadImageAction();
        }
        return null;
    }

    @MainThread
    public static void cancelWork(@Nullable ImageView view) {
        LoadImageAction<?> loadImageAction = ImageLoader.getLoadImageAction(view);
        if (loadImageAction != null) {
            loadImageAction.cancel();
        }
    }

    @MainThread
    public static boolean cancelPotentialWork(@NonNull ImageSource<?> source, @Nullable ImageView view) {
        LoadImageAction<?> loadImageAction = ImageLoader.getLoadImageAction(view);
        if (loadImageAction != null) {
            if (!Utils.equals(loadImageAction.getImageSource().getKey(), source.getKey())) {
                loadImageAction.cancel();
            } else {
                return false;
            }
        }
        return true;
    }

    public static int getMaxMemoryFraction(@FloatRange(from=0.1, to=0.8) float fraction) {
        if (fraction < 0.1f || fraction > 0.8f) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.1 and 0.8 (inclusive)");
        }
        return Math.round(fraction * (float)Runtime.getRuntime().maxMemory());
    }

    public static long getAvailableStorageFraction(@NonNull File path, @FloatRange(from=0.01, to=1.0) double fraction) {
        if (fraction < 0.01 || fraction > 1.0) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.01 and 1.0 (inclusive)");
        }
        return Math.round((double)Utils.getAvailableBytes(path) * fraction);
    }

    public static long getTotalStorageFraction(@NonNull File path, @FloatRange(from=0.01, to=1.0) double fraction) {
        if (fraction < 0.01 || fraction > 1.0) {
            throw new IllegalArgumentException("Argument \"fraction\" must be between 0.01 and 1.0 (inclusive)");
        }
        return Math.round((double)Utils.getTotalBytes(path) * fraction);
    }

    public static int calculateSampleSize(int sourceWidth, int sourceHeight, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        int sampleSize = 1;
        if (sourceWidth > requiredWidth || sourceHeight > requiredHeight) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            while (halfWidth / sampleSize > requiredWidth && halfHeight / sampleSize > requiredHeight) {
                sampleSize *= 2;
            }
            if (ignoreTotalNumberOfPixels) {
                return sampleSize;
            }
            long totalRequiredPixels = requiredWidth * requiredHeight;
            for (long totalPixels = (long)(sourceWidth * sourceHeight / (sampleSize * sampleSize)); totalPixels > totalRequiredPixels; totalPixels /= 4L) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUri(@NonNull Context context, @NonNull Uri uri, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        InputStream inputStream;
        BitmapFactory.Options options = null;
        if (requiredWidth != Integer.MAX_VALUE || requiredHeight != Integer.MAX_VALUE) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = null;
            try {
                inputStream = Utils.getDataStreamFromUri(context, uri);
                BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            catch (IOException e) {
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                Utils.close(inputStream);
            }
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageLoader.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        }
        inputStream = null;
        try {
            inputStream = Utils.getDataStreamFromUri(context, uri);
            Bitmap e = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return e;
        }
        catch (IOException e) {
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            Utils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFile(@NonNull File file, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        FileInputStream inputStream;
        BitmapFactory.Options options = null;
        if (requiredWidth != Integer.MAX_VALUE || requiredHeight != Integer.MAX_VALUE) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            catch (IOException e) {
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                Utils.close(inputStream);
            }
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageLoader.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        }
        inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Bitmap e = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (IOException e) {
            Bitmap bitmap;
            try {
                bitmap = null;
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
            Utils.close(inputStream);
            return bitmap;
        }
        Utils.close(inputStream);
        return e;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFileDescriptor(@NonNull FileDescriptor fileDescriptor, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        FileInputStream inputStream;
        BitmapFactory.Options options = null;
        if (requiredWidth != Integer.MAX_VALUE || requiredHeight != Integer.MAX_VALUE) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = new FileInputStream(fileDescriptor);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            Utils.close(inputStream);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageLoader.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        }
        inputStream = new FileInputStream(fileDescriptor);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        Utils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromResource(@NonNull Resources resources, int resourceId, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        TypedValue typedValue = new TypedValue();
        options.inJustDecodeBounds = true;
        options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        InputStream inputStream = resources.openRawResource(resourceId, typedValue);
        if (typedValue.density == 0) {
            options.inDensity = 160;
        } else if (typedValue.density != 65535) {
            options.inDensity = typedValue.density;
        }
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        Utils.close(inputStream);
        options.inJustDecodeBounds = false;
        if (requiredWidth != Integer.MAX_VALUE || requiredHeight != Integer.MAX_VALUE) {
            options.inSampleSize = ImageLoader.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        }
        inputStream = resources.openRawResource(resourceId, typedValue);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        Utils.close(inputStream);
        return bitmap;
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromByteArray(@NonNull byte[] byteArray, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = null;
        if (requiredWidth != Integer.MAX_VALUE || requiredHeight != Integer.MAX_VALUE) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
            options.inSampleSize = ImageLoader.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
            options.inJustDecodeBounds = false;
        }
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    @NonNull
    public static BitmapLoader<Uri> newUriBitmapLoader() {
        return new BitmapLoader<Uri>(){

            @Override
            @Nullable
            public Bitmap load(@NonNull Context context, Uri data) throws Exception {
                return ImageLoader.loadSampledBitmapFromUri(context, data, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
            }
        };
    }

    @NonNull
    public static BitmapLoader<File> newFileBitmapLoader() {
        return new BitmapLoader<File>(){

            @Override
            @Nullable
            public Bitmap load(@NonNull Context context, File data) throws Exception {
                return ImageLoader.loadSampledBitmapFromFile(data, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
            }
        };
    }

    @NonNull
    public static BitmapLoader<FileDescriptor> newFileDescriptorBitmapLoader() {
        return new BitmapLoader<FileDescriptor>(){

            @Override
            @Nullable
            public Bitmap load(@NonNull Context context, FileDescriptor data) throws Exception {
                return ImageLoader.loadSampledBitmapFromFileDescriptor(data, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
            }
        };
    }

    @NonNull
    public static BitmapLoader<Integer> newResourceBitmapLoader() {
        return new BitmapLoader<Integer>(){

            @Override
            @Nullable
            public Bitmap load(@NonNull Context context, Integer data) throws Exception {
                return ImageLoader.loadSampledBitmapFromResource(context.getResources(), data, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
            }
        };
    }

    @NonNull
    public static BitmapLoader<byte[]> newByteArrayBitmapLoader() {
        return new BitmapLoader<byte[]>(){

            @Override
            @Nullable
            public Bitmap load(@NonNull Context context, byte[] data) throws Exception {
                return ImageLoader.loadSampledBitmapFromByteArray(data, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
            }
        };
    }

    @NonNull
    public static <T> ImageSource<T> newImageSource(@NonNull T data) {
        return new ImageSourceImpl<T>(data);
    }

    @NonNull
    public static String generateSHA256(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_SHA256);
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static MemoryImageCache newMemoryImageCache(int maxSize) {
        return new MemoryImageCacheImpl(maxSize);
    }

    @NonNull
    public static MemoryImageCache newMemoryImageCache() {
        return ImageLoader.newMemoryImageCache(ImageLoader.getMaxMemoryFraction(0.25f));
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull File directory, long maxSize, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return new StorageImageCacheImpl(directory, maxSize, compressFormat, compressQuality);
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return ImageLoader.newStorageImageCache(directory, ImageLoader.getTotalStorageFraction(directory, 0.1), DEFAULT_COMPRESS_FORMAT, 85);
    }

    @NonNull
    public static StorageImageCache newStorageImageCache(@NonNull Context context) {
        return ImageLoader.newStorageImageCache(ImageLoader.getDefaultStorageCacheDirectory(context));
    }

    @NonNull
    public static File getDefaultStorageCacheDirectory(@NonNull Context context) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        return new File(cacheDir, DEFAULT_STORAGE_CACHE_DIRECTORY);
    }
}

