/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.budiyev.android.imageloader.FadeCallback;
import com.budiyev.android.imageloader.Utils;

@RequiresApi(value=19)
public class FadeDrawable
extends LayerDrawable
implements Drawable.Callback {
    private static final int FADE_NONE = 0;
    private static final int FADE_RUNNING = 1;
    private static final int FADE_DONE = 2;
    private static final int START_DRAWABLE = 0;
    private static final int END_DRAWABLE = 1;
    private static final int MAX_ALPHA = 255;
    private int mFadeState = 0;
    private long mStartTime;
    private long mDuration;
    private FadeCallback mFadeCallback;

    public FadeDrawable(@Nullable Drawable startDrawable, @Nullable Drawable endDrawable) {
        super(new Drawable[]{startDrawable, endDrawable});
        this.setId(0, 0);
        this.setId(1, 1);
    }

    private void draw(Canvas canvas, Drawable drawable, int alpha) {
        int originalAlpha = drawable.getAlpha();
        drawable.setAlpha(alpha);
        drawable.draw(canvas);
        drawable.setAlpha(originalAlpha);
    }

    public void draw(Canvas canvas) {
        Drawable endDrawable;
        if (this.mFadeState == 1) {
            Drawable endDrawable2;
            int alpha = Math.min(Math.round(255.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)this.mDuration), 255);
            Drawable startDrawable = this.getStartDrawable();
            if (startDrawable != null) {
                this.draw(canvas, startDrawable, 255 - alpha);
            }
            if ((endDrawable2 = this.getEndDrawable()) != null) {
                this.draw(canvas, endDrawable2, alpha);
            }
            if (alpha == 255) {
                this.mFadeState = 2;
                final FadeCallback fadeCallback = this.mFadeCallback;
                if (fadeCallback != null) {
                    Utils.runOnMainThread(new Runnable(){

                        @Override
                        @MainThread
                        public void run() {
                            fadeCallback.onEnd(FadeDrawable.this);
                        }
                    });
                }
            } else {
                this.invalidateSelf();
            }
        } else if (this.mFadeState == 0) {
            Drawable startDrawable = this.getStartDrawable();
            if (startDrawable != null) {
                this.draw(canvas, startDrawable, 255);
            }
        } else if (this.mFadeState == 2 && (endDrawable = this.getEndDrawable()) != null) {
            this.draw(canvas, endDrawable, 255);
        }
    }

    public void startFade(int duration) {
        this.mDuration = duration;
        this.mStartTime = System.currentTimeMillis();
        this.mFadeState = 1;
        this.invalidateSelf();
        final FadeCallback fadeCallback = this.mFadeCallback;
        if (fadeCallback != null) {
            Utils.runOnMainThread(new Runnable(){

                @Override
                @MainThread
                public void run() {
                    fadeCallback.onStart(FadeDrawable.this);
                }
            });
        }
    }

    public int getIntrinsicWidth() {
        Drawable drawable = this.getEndDrawable();
        if (drawable != null) {
            return drawable.getIntrinsicWidth();
        }
        return super.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        Drawable drawable = this.getEndDrawable();
        if (drawable != null) {
            return drawable.getIntrinsicHeight();
        }
        return super.getIntrinsicHeight();
    }

    public void resetFade() {
        this.mFadeState = 0;
        this.invalidateSelf();
    }

    @Nullable
    public Drawable getStartDrawable() {
        return this.getDrawable(0);
    }

    public void setStartDrawable(@Nullable Drawable startDrawable) {
        this.setDrawableByLayerId(0, startDrawable);
    }

    @Nullable
    public Drawable getEndDrawable() {
        return this.getDrawable(1);
    }

    public void setEndDrawable(@Nullable Drawable endDrawable) {
        this.setDrawableByLayerId(1, endDrawable);
    }

    @Nullable
    public FadeCallback getFadeCallback() {
        return this.mFadeCallback;
    }

    public void setFadeCallback(@Nullable FadeCallback fadeCallback) {
        this.mFadeCallback = fadeCallback;
    }
}

