/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.hardware.Camera;
import androidx.annotation.NonNull;
import com.budiyev.android.codescanner.Decoder;
import com.budiyev.android.codescanner.Point;

final class DecoderWrapper {
    private final Camera mCamera;
    private final Camera.CameraInfo mCameraInfo;
    private final Decoder mDecoder;
    private final Point mImageSize;
    private final Point mPreviewSize;
    private final Point mViewSize;
    private final int mDisplayOrientation;
    private final boolean mReverseHorizontal;
    private final boolean mAutoFocusSupported;
    private final boolean mFlashSupported;

    public DecoderWrapper(@NonNull Camera camera, @NonNull Camera.CameraInfo cameraInfo, @NonNull Decoder decoder, @NonNull Point imageSize, @NonNull Point previewSize, @NonNull Point viewSize, int displayOrientation, boolean autoFocusSupported, boolean flashSupported) {
        this.mCamera = camera;
        this.mCameraInfo = cameraInfo;
        this.mDecoder = decoder;
        this.mImageSize = imageSize;
        this.mPreviewSize = previewSize;
        this.mViewSize = viewSize;
        this.mDisplayOrientation = displayOrientation;
        this.mReverseHorizontal = cameraInfo.facing == 1;
        this.mAutoFocusSupported = autoFocusSupported;
        this.mFlashSupported = flashSupported;
    }

    @NonNull
    public Camera getCamera() {
        return this.mCamera;
    }

    @NonNull
    public Camera.CameraInfo getCameraInfo() {
        return this.mCameraInfo;
    }

    @NonNull
    public Decoder getDecoder() {
        return this.mDecoder;
    }

    @NonNull
    public Point getImageSize() {
        return this.mImageSize;
    }

    @NonNull
    public Point getPreviewSize() {
        return this.mPreviewSize;
    }

    @NonNull
    public Point getViewSize() {
        return this.mViewSize;
    }

    public int getDisplayOrientation() {
        return this.mDisplayOrientation;
    }

    public boolean shouldReverseHorizontal() {
        return this.mReverseHorizontal;
    }

    public boolean isAutoFocusSupported() {
        return this.mAutoFocusSupported;
    }

    public boolean isFlashSupported() {
        return this.mFlashSupported;
    }

    public void release() {
        this.mCamera.release();
        this.mDecoder.shutdown();
    }
}

