/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.budiyev.android.codescanner.Rect;

final class ViewFinderView
extends View {
    private final Paint mMaskPaint = new Paint(1);
    private final Paint mFramePaint = new Paint(1);
    private final Path mFramePath;
    private Rect mFrameRect;
    private int mFrameCornersSize;
    private float mFrameRatioWidth = 1.0f;
    private float mFrameRatioHeight = 1.0f;
    private float mFrameSize = 0.75f;

    public ViewFinderView(@NonNull Context context) {
        super(context);
        this.mFramePaint.setStyle(Paint.Style.STROKE);
        this.mFramePath = new Path();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        Rect frameRect = this.mFrameRect;
        if (frameRect == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int top = frameRect.getTop();
        int left = frameRect.getLeft();
        int right = frameRect.getRight();
        int bottom = frameRect.getBottom();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)top, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)top, (float)left, (float)bottom, this.mMaskPaint);
        canvas.drawRect((float)right, (float)top, (float)width, (float)bottom, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)bottom, (float)width, (float)height, this.mMaskPaint);
        this.mFramePath.reset();
        this.mFramePath.moveTo((float)left, (float)(top + this.mFrameCornersSize));
        this.mFramePath.lineTo((float)left, (float)top);
        this.mFramePath.lineTo((float)(left + this.mFrameCornersSize), (float)top);
        this.mFramePath.moveTo((float)(right - this.mFrameCornersSize), (float)top);
        this.mFramePath.lineTo((float)right, (float)top);
        this.mFramePath.lineTo((float)right, (float)(top + this.mFrameCornersSize));
        this.mFramePath.moveTo((float)right, (float)(bottom - this.mFrameCornersSize));
        this.mFramePath.lineTo((float)right, (float)bottom);
        this.mFramePath.lineTo((float)(right - this.mFrameCornersSize), (float)bottom);
        this.mFramePath.moveTo((float)(left + this.mFrameCornersSize), (float)bottom);
        this.mFramePath.lineTo((float)left, (float)bottom);
        this.mFramePath.lineTo((float)left, (float)(bottom - this.mFrameCornersSize));
        canvas.drawPath(this.mFramePath, this.mFramePaint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.invalidateFrameRect(right - left, bottom - top);
    }

    @Nullable
    Rect getFrameRect() {
        return this.mFrameRect;
    }

    void setFrameAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth, @FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioWidth = ratioWidth;
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.0, fromInclusive=false)
    float getFrameAspectRatioWidth() {
        return this.mFrameRatioWidth;
    }

    void setFrameAspectRatioWidth(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth) {
        this.mFrameRatioWidth = ratioWidth;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.0, fromInclusive=false)
    float getFrameAspectRatioHeight() {
        return this.mFrameRatioHeight;
    }

    void setFrameAspectRatioHeight(@FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @ColorInt
    int getMaskColor() {
        return this.mMaskPaint.getColor();
    }

    void setMaskColor(@ColorInt int color) {
        this.mMaskPaint.setColor(color);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @ColorInt
    int getFrameColor() {
        return this.mFramePaint.getColor();
    }

    void setFrameColor(@ColorInt int color) {
        this.mFramePaint.setColor(color);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @Px
    int getFrameThickness() {
        return (int)this.mFramePaint.getStrokeWidth();
    }

    void setFrameThickness(@Px int thickness) {
        this.mFramePaint.setStrokeWidth((float)thickness);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @Px
    int getFrameCornersSize() {
        return this.mFrameCornersSize;
    }

    void setFrameCornersSize(@Px int size) {
        this.mFrameCornersSize = size;
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.1, to=1.0)
    public float getFrameSize() {
        return this.mFrameSize;
    }

    void setFrameSize(@FloatRange(from=0.1, to=1.0) float size) {
        this.mFrameSize = size;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    private void invalidateFrameRect() {
        this.invalidateFrameRect(this.getWidth(), this.getHeight());
    }

    private void invalidateFrameRect(int width, int height) {
        if (width > 0 && height > 0) {
            int frameHeight;
            int frameWidth;
            float viewAR = (float)width / (float)height;
            float frameAR = this.mFrameRatioWidth / this.mFrameRatioHeight;
            if (viewAR <= frameAR) {
                frameWidth = Math.round((float)width * this.mFrameSize);
                frameHeight = Math.round((float)frameWidth / frameAR);
            } else {
                frameHeight = Math.round((float)height * this.mFrameSize);
                frameWidth = Math.round((float)frameHeight * frameAR);
            }
            int frameLeft = (width - frameWidth) / 2;
            int frameTop = (height - frameHeight) / 2;
            this.mFrameRect = new Rect(frameLeft, frameTop, frameLeft + frameWidth, frameTop + frameHeight);
        }
    }
}

