/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.budiyev.android.codescanner.CodeScanner;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.R;
import com.budiyev.android.codescanner.ViewFinderView;

public class CodeScannerView
extends ViewGroup {
    private static final boolean DEFAULT_SQUARE_FRAME = false;
    private static final boolean DEFAULT_AUTO_FOCUS_BUTTON_VISIBLE = true;
    private static final boolean DEFAULT_FLASH_BUTTON_VISIBLE = true;
    private static final int DEFAULT_AUTO_FOCUS_BUTTON_VISIBILITY = 0;
    private static final int DEFAULT_FLASH_BUTTON_VISIBILITY = 0;
    private static final int DEFAULT_MASK_COLOR = 0x77000000;
    private static final int DEFAULT_FRAME_COLOR = -1;
    private static final int DEFAULT_AUTO_FOCUS_BUTTON_COLOR = -1;
    private static final int DEFAULT_FLASH_BUTTON_COLOR = -1;
    private static final float DEFAULT_FRAME_WIDTH_DP = 2.0f;
    private static final float DEFAULT_FRAME_CORNER_SIZE_DP = 50.0f;
    private static final float BUTTON_SIZE_DP = 56.0f;
    private SurfaceView mPreviewView;
    private ViewFinderView mViewFinderView;
    private ImageView mAutoFocusButton;
    private ImageView mFlashButton;
    private Point mPreviewSize;
    private LayoutListener mLayoutListener;
    private CodeScanner mCodeScanner;
    private int mButtonSize;

    public CodeScannerView(@NonNull Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    @RequiresApi(value=21)
    public CodeScannerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mPreviewView = new SurfaceView(context);
        this.mPreviewView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mViewFinderView = new ViewFinderView(context);
        this.mViewFinderView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mButtonSize = Math.round(displayMetrics.density * 56.0f);
        this.mAutoFocusButton = new ImageView(context);
        this.mAutoFocusButton.setLayoutParams(new ViewGroup.LayoutParams(this.mButtonSize, this.mButtonSize));
        this.mAutoFocusButton.setScaleType(ImageView.ScaleType.CENTER);
        this.mAutoFocusButton.setImageResource(R.drawable.ic_code_scanner_auto_focus_on);
        this.mAutoFocusButton.setOnClickListener((View.OnClickListener)new AutoFocusClickListener());
        this.mFlashButton = new ImageView(context);
        this.mFlashButton.setLayoutParams(new ViewGroup.LayoutParams(this.mButtonSize, this.mButtonSize));
        this.mFlashButton.setScaleType(ImageView.ScaleType.CENTER);
        this.mFlashButton.setImageResource(R.drawable.ic_code_scanner_flash_on);
        this.mFlashButton.setOnClickListener((View.OnClickListener)new FlashClickListener());
        if (attrs == null) {
            this.mViewFinderView.setSquareFrame(false);
            this.mViewFinderView.setMaskColor(0x77000000);
            this.mViewFinderView.setFrameColor(-1);
            this.mViewFinderView.setFrameWidth(Math.round(2.0f * displayMetrics.density));
            this.mViewFinderView.setFrameCornersSize(Math.round(50.0f * displayMetrics.density));
            this.mAutoFocusButton.setColorFilter(-1);
            this.mFlashButton.setColorFilter(-1);
            this.mAutoFocusButton.setVisibility(0);
            this.mFlashButton.setVisibility(0);
        } else {
            TypedArray attributes = null;
            try {
                attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CodeScannerView, defStyleAttr, defStyleRes);
                this.mViewFinderView.setSquareFrame(attributes.getBoolean(R.styleable.CodeScannerView_squareFrame, false));
                this.mViewFinderView.setMaskColor(attributes.getColor(R.styleable.CodeScannerView_maskColor, 0x77000000));
                this.mViewFinderView.setFrameColor(attributes.getColor(R.styleable.CodeScannerView_frameColor, -1));
                this.mViewFinderView.setFrameWidth(attributes.getDimensionPixelSize(R.styleable.CodeScannerView_frameWidth, Math.round(2.0f * displayMetrics.density)));
                this.mViewFinderView.setFrameCornersSize(attributes.getDimensionPixelSize(R.styleable.CodeScannerView_frameCornersSize, Math.round(50.0f * displayMetrics.density)));
                this.mAutoFocusButton.setColorFilter(attributes.getColor(R.styleable.CodeScannerView_autoFocusButtonColor, -1));
                this.mFlashButton.setColorFilter(attributes.getColor(R.styleable.CodeScannerView_flashButtonColor, -1));
                this.mAutoFocusButton.setVisibility(attributes.getBoolean(R.styleable.CodeScannerView_autoFocusButtonVisible, true) ? 0 : 4);
                this.mFlashButton.setVisibility(attributes.getBoolean(R.styleable.CodeScannerView_flashButtonVisible, true) ? 0 : 4);
            }
            finally {
                if (attributes != null) {
                    attributes.recycle();
                }
            }
        }
        this.addView((View)this.mPreviewView);
        this.addView(this.mViewFinderView);
        this.addView((View)this.mAutoFocusButton);
        this.addView((View)this.mFlashButton);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        Point previewSize = this.mPreviewSize;
        if (previewSize == null) {
            this.mPreviewView.layout(0, 0, width, height);
        } else {
            int previewHeight;
            int frameLeft = 0;
            int frameTop = 0;
            int frameRight = width;
            int frameBottom = height;
            int previewWidth = previewSize.getX();
            if (previewWidth > width) {
                int d = (previewWidth - width) / 2;
                frameLeft -= d;
                frameRight += d;
            }
            if ((previewHeight = previewSize.getY()) > height) {
                int d = (previewHeight - height) / 2;
                frameTop -= d;
                frameBottom += d;
            }
            this.mPreviewView.layout(frameLeft, frameTop, frameRight, frameBottom);
        }
        this.mViewFinderView.layout(0, 0, width, height);
        int buttonSize = this.mButtonSize;
        this.mAutoFocusButton.layout(0, 0, buttonSize, buttonSize);
        this.mFlashButton.layout(width - buttonSize, 0, width, buttonSize);
        LayoutListener listener = this.mLayoutListener;
        if (listener != null) {
            listener.onLayout(width, height);
        }
    }

    public void setSquareFrame(boolean squareFrame) {
        this.mViewFinderView.setSquareFrame(squareFrame);
    }

    public void setMaskColor(@ColorInt int color) {
        this.mViewFinderView.setMaskColor(color);
    }

    public void setFrameColor(@ColorInt int color) {
        this.mViewFinderView.setFrameColor(color);
    }

    public void setFrameWidth(@Px int width) {
        this.mViewFinderView.setFrameWidth(width);
    }

    public void setFrameCornersSize(@Px int size) {
        this.mViewFinderView.setFrameCornersSize(size);
    }

    public void setAutoFocusButtonVisible(boolean visible) {
        if (visible) {
            this.mAutoFocusButton.setVisibility(0);
        } else {
            this.mAutoFocusButton.setVisibility(4);
        }
    }

    public void setFlashButtonVisible(boolean visible) {
        if (visible) {
            this.mFlashButton.setVisibility(0);
        } else {
            this.mFlashButton.setVisibility(4);
        }
    }

    boolean isSquareFrame() {
        return this.mViewFinderView.isSquareFrame();
    }

    SurfaceView getPreviewView() {
        return this.mPreviewView;
    }

    ViewFinderView getViewFinderView() {
        return this.mViewFinderView;
    }

    void setPreviewSize(@Nullable Point previewSize) {
        this.mPreviewSize = previewSize;
        this.requestLayout();
    }

    void setLayoutListener(@Nullable LayoutListener layoutListener) {
        this.mLayoutListener = layoutListener;
    }

    void setCodeScanner(@NonNull CodeScanner codeScanner) {
        if (this.mCodeScanner != null) {
            throw new IllegalStateException("Code scanner has already been set");
        }
        this.mCodeScanner = codeScanner;
        this.setAutoFocusEnabled(codeScanner.isAutoFocusEnabled());
        this.setFlashEnabled(codeScanner.isFlashEnabled());
    }

    void setAutoFocusEnabled(boolean enabled) {
        if (enabled) {
            this.mAutoFocusButton.setImageResource(R.drawable.ic_code_scanner_auto_focus_on);
        } else {
            this.mAutoFocusButton.setImageResource(R.drawable.ic_code_scanner_auto_focus_off);
        }
    }

    void setFlashEnabled(boolean enabled) {
        if (enabled) {
            this.mFlashButton.setImageResource(R.drawable.ic_code_scanner_flash_on);
        } else {
            this.mFlashButton.setImageResource(R.drawable.ic_code_scanner_flash_off);
        }
    }

    private final class FlashClickListener
    implements View.OnClickListener {
        private FlashClickListener() {
        }

        public void onClick(View view) {
            CodeScanner scanner = CodeScannerView.this.mCodeScanner;
            if (scanner == null || !scanner.isFlashSupportedOrUnknown()) {
                return;
            }
            boolean enabled = !scanner.isFlashEnabled();
            scanner.setFlashEnabled(enabled);
            CodeScannerView.this.setFlashEnabled(enabled);
        }
    }

    private final class AutoFocusClickListener
    implements View.OnClickListener {
        private AutoFocusClickListener() {
        }

        public void onClick(View view) {
            CodeScanner scanner = CodeScannerView.this.mCodeScanner;
            if (scanner == null || !scanner.isAutoFocusSupportedOrUnknown()) {
                return;
            }
            boolean enabled = !scanner.isAutoFocusEnabled();
            scanner.setAutoFocusEnabled(enabled);
            CodeScannerView.this.setAutoFocusEnabled(enabled);
        }
    }

    static interface LayoutListener {
        public void onLayout(int var1, int var2);
    }
}

