/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.SurfaceHolder;
import android.view.View;
import com.budiyev.android.codescanner.CodeScannerView;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.Decoder;
import com.budiyev.android.codescanner.DecoderWrapper;
import com.budiyev.android.codescanner.ErrorCallback;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.BarcodeFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class CodeScanner {
    public static final List<BarcodeFormat> ALL_FORMATS = Arrays.asList(BarcodeFormat.AZTEC, BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.DATA_MATRIX, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION);
    public static final List<BarcodeFormat> ONE_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION);
    public static final List<BarcodeFormat> TWO_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.AZTEC, BarcodeFormat.DATA_MATRIX, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE);
    private static final long AUTO_FOCUS_INTERVAL = 1500L;
    private static final int UNSPECIFIED = -1;
    private static final int FOCUS_ATTEMPTS_THRESHOLD = 2;
    private final Lock mInitializeLock = new ReentrantLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final CodeScannerView mScannerView;
    private final SurfaceHolder mSurfaceHolder;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final Camera.PreviewCallback mPreviewCallback;
    private final Camera.AutoFocusCallback mAutoFocusCallback;
    private final Runnable mAutoFocusTask;
    private final Runnable mStopPreviewTask;
    private final DecoderStateListener mDecoderStateListener;
    private final int mCameraId;
    private volatile List<BarcodeFormat> mFormats = ALL_FORMATS;
    private volatile DecodeCallback mDecodeCallback;
    private volatile ErrorCallback mErrorCallback;
    private volatile DecoderWrapper mDecoderWrapper;
    private volatile boolean mInitialization;
    private volatile boolean mInitialized;
    private volatile boolean mStoppingPreview;
    private volatile boolean mAutoFocusEnabled = true;
    private volatile boolean mFlashEnabled;
    private boolean mPreviewActive;
    private boolean mFocusing;
    private int mFocusAttemptsCount;

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view) {
        this(context, view, -1);
    }

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view, int cameraId) {
        this.mContext = context;
        this.mScannerView = view;
        this.mSurfaceHolder = view.getPreviewView().getHolder();
        this.mMainThreadHandler = new Handler();
        this.mSurfaceCallback = new SurfaceCallback();
        this.mPreviewCallback = new PreviewCallback();
        this.mAutoFocusCallback = new AutoFocusCallback();
        this.mAutoFocusTask = new AutoFocusTask();
        this.mStopPreviewTask = new StopPreviewTask();
        this.mDecoderStateListener = new DecoderStateListener();
        this.mCameraId = cameraId;
        this.mScannerView.setCodeScanner(this);
    }

    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mInitializeLock.lock();
        try {
            if (this.mInitialized) {
                this.mDecoderWrapper.getDecoder().setFormats(formats);
            } else {
                this.mFormats = formats;
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public void setFormats(BarcodeFormat ... formats) {
        this.setFormats(Arrays.asList(formats));
    }

    public void setFormat(@NonNull BarcodeFormat format) {
        this.setFormats(Collections.singletonList(format));
    }

    public void setDecodeCallback(@Nullable DecodeCallback decodeCallback) {
        this.mDecodeCallback = decodeCallback;
    }

    public void setErrorCallback(@Nullable ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    public void setAutoFocusEnabled(boolean autoFocusEnabled) {
        this.mInitializeLock.lock();
        try {
            boolean changed = this.mAutoFocusEnabled != autoFocusEnabled;
            this.mAutoFocusEnabled = autoFocusEnabled;
            this.mScannerView.setAutoFocusEnabled(autoFocusEnabled);
            if (this.mInitialized && this.mPreviewActive && changed && this.mDecoderWrapper.isAutoFocusSupported()) {
                this.setAutoFocusEnabledInternal(autoFocusEnabled);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.mAutoFocusEnabled;
    }

    public void setFlashEnabled(boolean flashEnabled) {
        this.mInitializeLock.lock();
        try {
            boolean changed = this.mFlashEnabled != flashEnabled;
            this.mFlashEnabled = flashEnabled;
            this.mScannerView.setFlashEnabled(flashEnabled);
            if (this.mInitialized && this.mPreviewActive && changed && this.mDecoderWrapper.isFlashSupported()) {
                this.setFlashEnabledInternal(flashEnabled);
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public boolean isFlashEnabled() {
        return this.mFlashEnabled;
    }

    public boolean isPreviewActive() {
        return this.mPreviewActive;
    }

    @MainThread
    public void startPreview() {
        this.mInitializeLock.lock();
        try {
            if (!this.mInitialized && !this.mInitialization) {
                this.mInitialization = true;
                this.initialize();
                return;
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
        if (!this.mPreviewActive) {
            this.mSurfaceHolder.addCallback(this.mSurfaceCallback);
            this.startPreviewInternal(false);
        }
    }

    @MainThread
    public void stopPreview() {
        if (this.mInitialized && this.mPreviewActive) {
            this.mSurfaceHolder.removeCallback(this.mSurfaceCallback);
            this.stopPreviewInternal(false);
        }
    }

    @MainThread
    public void releaseResources() {
        if (this.mInitialized) {
            if (this.mPreviewActive) {
                this.stopPreview();
            }
            this.releaseResourcesInternal();
        }
    }

    private void initialize() {
        if (Utils.isLaidOut((View)this.mScannerView)) {
            this.initialize(this.mScannerView.getWidth(), this.mScannerView.getHeight());
        } else {
            this.mScannerView.setLayoutListener(new ScannerLayoutListener());
        }
    }

    private void initialize(int width, int height) {
        new InitializationThread(width, height).start();
    }

    private void startPreviewInternal(boolean internal) {
        try {
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            camera.setPreviewCallback(this.mPreviewCallback);
            camera.setPreviewDisplay(this.mSurfaceHolder);
            if (!internal && decoderWrapper.isFlashSupported() && this.mFlashEnabled) {
                this.setFlashEnabledInternal(true);
            }
            camera.startPreview();
            this.mStoppingPreview = false;
            this.mPreviewActive = true;
            this.mFocusing = false;
            this.mFocusAttemptsCount = 0;
            this.scheduleAutoFocusTask();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPreviewInternalSafe() {
        if (this.mInitialized && !this.mPreviewActive) {
            this.startPreviewInternal(true);
        }
    }

    private void stopPreviewInternal(boolean internal) {
        try {
            Camera.Parameters parameters;
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            if (!internal && decoderWrapper.isFlashSupported() && this.mFlashEnabled && (parameters = camera.getParameters()) != null && Utils.setFlashMode(parameters, "off")) {
                camera.setParameters(parameters);
            }
            camera.setPreviewCallback(null);
            camera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mStoppingPreview = false;
        this.mPreviewActive = false;
        this.mFocusing = false;
        this.mFocusAttemptsCount = 0;
    }

    private void stopPreviewInternalSafe() {
        if (this.mInitialized && this.mPreviewActive) {
            this.stopPreviewInternal(true);
        }
    }

    private void releaseResourcesInternal() {
        this.mInitialized = false;
        this.mInitialization = false;
        this.mStoppingPreview = false;
        this.mPreviewActive = false;
        this.mFocusing = false;
        DecoderWrapper decoderWrapper = this.mDecoderWrapper;
        if (decoderWrapper != null) {
            this.mDecoderWrapper = null;
            decoderWrapper.release();
        }
    }

    private void setFlashEnabledInternal(boolean flashEnabled) {
        try {
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                return;
            }
            boolean changed = flashEnabled ? Utils.setFlashMode(parameters, "torch") : Utils.setFlashMode(parameters, "off");
            if (changed) {
                camera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAutoFocusEnabledInternal(boolean autoFocusEnabled) {
        try {
            boolean changed;
            DecoderWrapper decoderWrapper = this.mDecoderWrapper;
            Camera camera = decoderWrapper.getCamera();
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                return;
            }
            if (autoFocusEnabled) {
                changed = Utils.setFocusMode(parameters, "auto");
            } else {
                camera.cancelAutoFocus();
                changed = Utils.setFocusMode(parameters, "fixed");
            }
            if (changed) {
                camera.setParameters(parameters);
            }
            if (autoFocusEnabled) {
                this.scheduleAutoFocusTask();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void autoFocusCamera() {
        if (!this.mInitialized || !this.mPreviewActive) {
            return;
        }
        if (!this.mDecoderWrapper.isAutoFocusSupported() || !this.mAutoFocusEnabled) {
            return;
        }
        if (this.mFocusing && this.mFocusAttemptsCount < 2) {
            ++this.mFocusAttemptsCount;
        } else {
            try {
                this.mDecoderWrapper.getCamera().autoFocus(this.mAutoFocusCallback);
                this.mFocusAttemptsCount = 0;
                this.mFocusing = true;
            }
            catch (Exception e) {
                this.mFocusing = false;
            }
        }
        this.scheduleAutoFocusTask();
    }

    private void scheduleAutoFocusTask() {
        this.mMainThreadHandler.postDelayed(this.mAutoFocusTask, 1500L);
    }

    boolean isAutoFocusSupportedOrUnknown() {
        DecoderWrapper wrapper = this.mDecoderWrapper;
        return wrapper == null || wrapper.isAutoFocusSupported();
    }

    boolean isFlashSupportedOrUnknown() {
        DecoderWrapper wrapper = this.mDecoderWrapper;
        return wrapper == null || wrapper.isFlashSupported();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int mCameraId = -1;
        private List<BarcodeFormat> mFormats = ALL_FORMATS;
        private DecodeCallback mDecodeCallback;
        private ErrorCallback mErrorCallback;
        private boolean mAutoFocusEnabled = true;
        private boolean mFlashEnabled;

        private Builder() {
        }

        @NonNull
        public Builder camera(int cameraId) {
            this.mCameraId = cameraId;
            return this;
        }

        @NonNull
        public Builder formats(BarcodeFormat ... formats) {
            this.mFormats = Arrays.asList(formats);
            return this;
        }

        @NonNull
        public Builder formats(@NonNull List<BarcodeFormat> formats) {
            this.mFormats = formats;
            return this;
        }

        @NonNull
        public Builder onDecoded(@Nullable DecodeCallback callback) {
            this.mDecodeCallback = callback;
            return this;
        }

        @NonNull
        public Builder onError(@Nullable ErrorCallback callback) {
            this.mErrorCallback = callback;
            return this;
        }

        @NonNull
        public Builder autoFocus(boolean enabled) {
            this.mAutoFocusEnabled = enabled;
            return this;
        }

        @NonNull
        public Builder flash(boolean enabled) {
            this.mFlashEnabled = enabled;
            return this;
        }

        @NonNull
        public CodeScanner build(@NonNull Context context, @NonNull CodeScannerView view) {
            CodeScanner scanner = new CodeScanner(context, view, this.mCameraId);
            scanner.mFormats = this.mFormats;
            scanner.mDecodeCallback = this.mDecodeCallback;
            scanner.mErrorCallback = this.mErrorCallback;
            scanner.mAutoFocusEnabled = this.mAutoFocusEnabled;
            scanner.mFlashEnabled = this.mFlashEnabled;
            return scanner;
        }
    }

    private final class FinishInitializationTask
    implements Runnable {
        private final Point mFrameSize;

        private FinishInitializationTask(Point frameSize) {
            this.mFrameSize = frameSize;
        }

        @Override
        public void run() {
            if (!CodeScanner.this.mInitialized) {
                return;
            }
            CodeScanner.this.mScannerView.setFrameSize(this.mFrameSize);
            CodeScanner.this.mScannerView.setCodeScanner(CodeScanner.this);
            CodeScanner.this.startPreview();
        }
    }

    private final class StopPreviewTask
    implements Runnable {
        private StopPreviewTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.stopPreview();
        }
    }

    private final class AutoFocusTask
    implements Runnable {
        private AutoFocusTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.autoFocusCamera();
        }
    }

    private final class AutoFocusCallback
    implements Camera.AutoFocusCallback {
        private AutoFocusCallback() {
        }

        public void onAutoFocus(boolean success, Camera camera) {
            CodeScanner.this.mFocusing = false;
        }
    }

    private final class InitializationThread
    extends Thread {
        private final int mWidth;
        private final int mHeight;

        public InitializationThread(int width, int height) {
            super("Code scanner initialization thread");
            if (this.getPriority() != 5) {
                this.setPriority(5);
            }
            if (this.isDaemon()) {
                this.setDaemon(false);
            }
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        public void run() {
            try {
                this.initialize();
            }
            catch (Exception e) {
                CodeScanner.this.releaseResourcesInternal();
                ErrorCallback errorCallback = CodeScanner.this.mErrorCallback;
                if (errorCallback != null) {
                    errorCallback.onError(e);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            List flashModes;
            boolean flashSupported;
            boolean autoFocusSupported;
            Camera camera = null;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            if (CodeScanner.this.mCameraId == -1) {
                int numberOfCameras = Camera.getNumberOfCameras();
                for (int i = 0; i < numberOfCameras; ++i) {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    camera = Camera.open((int)i);
                    break;
                }
            } else {
                camera = Camera.open((int)CodeScanner.this.mCameraId);
                Camera.getCameraInfo((int)CodeScanner.this.mCameraId, (Camera.CameraInfo)cameraInfo);
            }
            if (camera == null) {
                throw new RuntimeException("Unable to access camera");
            }
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                throw new RuntimeException("Unable to configure camera");
            }
            int orientation = Utils.getDisplayOrientation(CodeScanner.this.mContext, cameraInfo);
            boolean portrait = Utils.isPortrait(orientation);
            Point previewSize = Utils.findSuitablePreviewSize(parameters, portrait ? this.mHeight : this.mWidth, portrait ? this.mWidth : this.mHeight);
            parameters.setPreviewSize(previewSize.x, previewSize.y);
            Point frameSize = Utils.getFrameSize(portrait ? previewSize.y : previewSize.x, portrait ? previewSize.x : previewSize.y, this.mWidth, this.mHeight);
            List focusModes = parameters.getSupportedFocusModes();
            boolean bl = autoFocusSupported = focusModes != null && focusModes.contains("auto");
            if (!autoFocusSupported) {
                CodeScanner.this.mAutoFocusEnabled = false;
            }
            if (autoFocusSupported && CodeScanner.this.mAutoFocusEnabled) {
                parameters.setFocusMode("auto");
            }
            boolean bl2 = flashSupported = (flashModes = parameters.getSupportedFlashModes()) != null && flashModes.contains("torch");
            if (!flashSupported) {
                CodeScanner.this.mFlashEnabled = false;
            }
            camera.setParameters(Utils.optimizeParameters(parameters));
            camera.setDisplayOrientation(orientation);
            CodeScanner.this.mInitializeLock.lock();
            try {
                Decoder decoder = new Decoder(CodeScanner.this.mDecoderStateListener, CodeScanner.this.mFormats);
                CodeScanner.this.mDecoderWrapper = new DecoderWrapper(camera, cameraInfo, decoder, previewSize, frameSize, orientation, autoFocusSupported, flashSupported);
                decoder.start();
                CodeScanner.this.mInitialization = false;
                CodeScanner.this.mInitialized = true;
            }
            finally {
                CodeScanner.this.mInitializeLock.unlock();
            }
            CodeScanner.this.mMainThreadHandler.post((Runnable)new FinishInitializationTask(frameSize));
        }
    }

    private final class DecoderStateListener
    implements Decoder.StateListener {
        private DecoderStateListener() {
        }

        @Override
        public void onStateChanged(int state) {
            if (state == 2) {
                CodeScanner.this.mStoppingPreview = true;
                CodeScanner.this.mMainThreadHandler.post(CodeScanner.this.mStopPreviewTask);
            }
        }
    }

    private final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            CodeScanner.this.startPreviewInternalSafe();
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder.getSurface() == null) {
                CodeScanner.this.mPreviewActive = false;
                return;
            }
            CodeScanner.this.stopPreviewInternalSafe();
            CodeScanner.this.startPreviewInternalSafe();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            CodeScanner.this.stopPreviewInternalSafe();
        }
    }

    private final class PreviewCallback
    implements Camera.PreviewCallback {
        private PreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            if (!CodeScanner.this.mInitialized || CodeScanner.this.mStoppingPreview) {
                return;
            }
            DecoderWrapper decoderWrapper = CodeScanner.this.mDecoderWrapper;
            Decoder decoder = decoderWrapper.getDecoder();
            if (decoder.isProcessing()) {
                return;
            }
            Point previewSize = decoderWrapper.getPreviewSize();
            Point frameSize = decoderWrapper.getFrameSize();
            decoder.decode(data, previewSize.x, previewSize.y, frameSize.x, frameSize.y, decoderWrapper.getDisplayOrientation(), CodeScanner.this.mScannerView.isSquareFrame(), decoderWrapper.getCameraInfo().facing == 1, CodeScanner.this.mDecodeCallback);
        }
    }

    private final class ScannerLayoutListener
    implements CodeScannerView.LayoutListener {
        private ScannerLayoutListener() {
        }

        @Override
        public void onLayout(int width, int height) {
            CodeScanner.this.initialize(width, height);
            CodeScanner.this.mScannerView.setLayoutListener(null);
        }
    }
}

