/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.selenium.junit4.rule;

import com.btmatthews.selenium.junit4.rule.ScreenShotFilenameGenerator;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.junit.runner.Description;

public class DefaultScreenShotFilenameGenerator
implements ScreenShotFilenameGenerator {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    private final File target;

    public DefaultScreenShotFilenameGenerator(File directory) {
        this.target = directory;
    }

    public File getTargetFilename(Description description) {
        StringBuilder builder = new StringBuilder();
        builder.append(description.getMethodName());
        builder.append('-');
        builder.append(DATE_FORMAT.format(new Date()));
        builder.append('-');
        builder.append(UUID.randomUUID().toString());
        builder.append(".png");
        return new File(new File(this.target, description.getTestClass().getCanonicalName().replace('.', File.separatorChar)), builder.toString());
    }
}

